library(rearrr)
context("n_fn")

test_that("testing create_n_fn()", {
  xpectr::set_test_seed(42)

  # Create three vectors
  x <- runif(10)
  y <- runif(10)
  z <- runif(10)

  z[[1]] <- NA

  n_fn <- create_n_fn(median, negate = TRUE, round_fn = ceiling, na.rm = TRUE)

  ## Testing 'n_fn(x,y,z)'                                                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_17375 <- n_fn(x,y,z)
  # Testing class
  expect_equal(
    class(output_17375),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17375,
    type = "double")
  # Testing values
  expect_equal(
    output_17375,
    c(-1, -1, -1),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_17375),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_17375),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_17375)),
    3L)
  ## Finished testing 'n_fn(x,y,z)'                                         ####


  n_fn <- create_n_fn(median, negate = TRUE, round_fn = ceiling, na.rm = FALSE)

  ## Testing 'n_fn(x,y,z)'                                                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- n_fn(x,y,z)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(-1, -1, NA),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'n_fn(x,y,z)'                                         ####


  n_fn <- create_n_fn(median, negate = FALSE, round_fn = identity, na.rm = FALSE)


  ## Testing 'n_fn(x, y, z)'                                                ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- n_fn(x, y, z)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(0.68103, 0.51766, NA),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'n_fn(x, y, z)'                                       ####

  n_fn <- create_n_fn(median, negate = FALSE, round_fn = floor, na.rm = TRUE)


  ## Testing 'n_fn(x, y, z)'                                                ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- n_fn(x, y, z)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(0, 0, 0),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'n_fn(x, y, z)'                                       ####


})

test_that("fuzz testing create_n_fn()", {
  xpectr::set_test_seed(42)

  # We can't check function definitions when running covr::*
  testthat::skip_if(covr::in_covr())

  # Create three vectors
  x <- runif(10)
  y <- runif(10)
  z <- runif(10)


  # Generate expectations for 'create_n_fn'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = create_n_fn,
  #   args_values = list(
  #     "fn" = list(median, mean, identity, function(x){1}),
  #     "use_index" = list(TRUE, FALSE, 1, NA),
  #     "negate" = list(FALSE, TRUE, 1, NA),
  #     "round_fn" = list(round, floor, ceiling, identity, 1, NA)
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'create_n_fn'                                                    ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing create_n_fn(fn = median, use_index = TRUE, n...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- create_n_fn(fn = median, use_index = TRUE, negate = FALSE, round_fn = round)
  # Testing is function
  expect_true(
    is.function(output_19148))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_19148),
    "...",
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_19148),
    c("function (...) ", "{", "    input <- list(...)", "    if (isTRUE(use_index)) {",
      "        input <- input %>% purrr::map(.f = ~{", "            seq_along(.x)",
      "        })", "    }", "    input %>% purrr::map(.f = function(x) {",
      "        negate_fn(round_fn(rlang::exec(.fn = fn, x, !!!args)))",
      "    }) %>% unlist(recursive = TRUE, use.names = FALSE)", "}"),
    fixed = TRUE)

  # Testing create_n_fn(fn = mean, use_index = TRUE, neg...
  # Changed from baseline: fn = mean
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- create_n_fn(fn = mean, use_index = TRUE, negate = FALSE, round_fn = round)
  # Testing is function
  expect_true(
    is.function(output_19370))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_19370),
    "...",
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_19370),
    c("function (...) ", "{", "    input <- list(...)", "    if (isTRUE(use_index)) {",
      "        input <- input %>% purrr::map(.f = ~{", "            seq_along(.x)",
      "        })", "    }", "    input %>% purrr::map(.f = function(x) {",
      "        negate_fn(round_fn(rlang::exec(.fn = fn, x, !!!args)))",
      "    }) %>% unlist(recursive = TRUE, use.names = FALSE)", "}"),
    fixed = TRUE)

  # Testing create_n_fn(fn = identity, use_index = TRUE,...
  # Changed from baseline: fn = identity
  xpectr::set_test_seed(42)
  # Assigning output
  output_12861 <- create_n_fn(fn = identity, use_index = TRUE, negate = FALSE, round_fn = round)
  # Testing is function
  expect_true(
    is.function(output_12861))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_12861),
    "...",
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_12861),
    c("function (...) ", "{", "    input <- list(...)", "    if (isTRUE(use_index)) {",
      "        input <- input %>% purrr::map(.f = ~{", "            seq_along(.x)",
      "        })", "    }", "    input %>% purrr::map(.f = function(x) {",
      "        negate_fn(round_fn(rlang::exec(.fn = fn, x, !!!args)))",
      "    }) %>% unlist(recursive = TRUE, use.names = FALSE)", "}"),
    fixed = TRUE)

  # Testing create_n_fn(fn = function(x) { 1}, use_index...
  # Changed from baseline: fn = function(x) { 1}
  xpectr::set_test_seed(42)
  # Assigning output
  output_18304 <- create_n_fn(fn = function(x) {
      1
  }, use_index = TRUE, negate = FALSE, round_fn = round)
  # Testing is function
  expect_true(
    is.function(output_18304))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_18304),
    "...",
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_18304),
    c("function (...) ", "{", "    input <- list(...)", "    if (isTRUE(use_index)) {",
      "        input <- input %>% purrr::map(.f = ~{", "            seq_along(.x)",
      "        })", "    }", "    input %>% purrr::map(.f = function(x) {",
      "        negate_fn(round_fn(rlang::exec(.fn = fn, x, !!!args)))",
      "    }) %>% unlist(recursive = TRUE, use.names = FALSE)", "}"),
    fixed = TRUE)

  # Testing create_n_fn(fn = NULL, use_index = TRUE, neg...
  # Changed from baseline: fn = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(create_n_fn(fn = NULL, use_index = TRUE, negate = FALSE, round_fn = round), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'fn': Must be a function, not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = FALSE, ...
  # Changed from baseline: use_index = FALSE
  xpectr::set_test_seed(42)
  # Assigning output
  output_15190 <- create_n_fn(fn = median, use_index = FALSE, negate = FALSE, round_fn = round)
  # Testing is function
  expect_true(
    is.function(output_15190))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_15190),
    "...",
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_15190),
    c("function (...) ", "{", "    input <- list(...)", "    if (isTRUE(use_index)) {",
      "        input <- input %>% purrr::map(.f = ~{", "            seq_along(.x)",
      "        })", "    }", "    input %>% purrr::map(.f = function(x) {",
      "        negate_fn(round_fn(rlang::exec(.fn = fn, x, !!!args)))",
      "    }) %>% unlist(recursive = TRUE, use.names = FALSE)", "}"),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = 1, nega...
  # Changed from baseline: use_index = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(create_n_fn(fn = median, use_index = 1, negate = FALSE, round_fn = round), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'use_index': Must be of type 'logical flag', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = NA, neg...
  # Changed from baseline: use_index = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(create_n_fn(fn = median, use_index = NA, negate = FALSE, round_fn = round), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'use_index': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = NULL, n...
  # Changed from baseline: use_index = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(create_n_fn(fn = median, use_index = NULL, negate = FALSE, round_fn = round), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'use_index': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = TRUE, n...
  # Changed from baseline: negate = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_17050 <- create_n_fn(fn = median, use_index = TRUE, negate = TRUE, round_fn = round)
  # Testing is function
  expect_true(
    is.function(output_17050))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_17050),
    "...",
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_17050),
    c("function (...) ", "{", "    input <- list(...)", "    if (isTRUE(use_index)) {",
      "        input <- input %>% purrr::map(.f = ~{", "            seq_along(.x)",
      "        })", "    }", "    input %>% purrr::map(.f = function(x) {",
      "        negate_fn(round_fn(rlang::exec(.fn = fn, x, !!!args)))",
      "    }) %>% unlist(recursive = TRUE, use.names = FALSE)", "}"),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = TRUE, n...
  # Changed from baseline: negate = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(create_n_fn(fn = median, use_index = TRUE, negate = 1, round_fn = round), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'negate': Must be of type 'logical flag', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = TRUE, n...
  # Changed from baseline: negate = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(create_n_fn(fn = median, use_index = TRUE, negate = NA, round_fn = round), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'negate': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = TRUE, n...
  # Changed from baseline: negate = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(create_n_fn(fn = median, use_index = TRUE, negate = NULL, round_fn = round), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'negate': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = TRUE, n...
  # Changed from baseline: round_fn = floor
  xpectr::set_test_seed(42)
  # Assigning output
  output_12554 <- create_n_fn(fn = median, use_index = TRUE, negate = FALSE, round_fn = floor)
  # Testing is function
  expect_true(
    is.function(output_12554))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_12554),
    "...",
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_12554),
    c("function (...) ", "{", "    input <- list(...)", "    if (isTRUE(use_index)) {",
      "        input <- input %>% purrr::map(.f = ~{", "            seq_along(.x)",
      "        })", "    }", "    input %>% purrr::map(.f = function(x) {",
      "        negate_fn(round_fn(rlang::exec(.fn = fn, x, !!!args)))",
      "    }) %>% unlist(recursive = TRUE, use.names = FALSE)", "}"),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = TRUE, n...
  # Changed from baseline: round_fn = ceiling
  xpectr::set_test_seed(42)
  # Assigning output
  output_14622 <- create_n_fn(fn = median, use_index = TRUE, negate = FALSE, round_fn = ceiling)
  # Testing is function
  expect_true(
    is.function(output_14622))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_14622),
    "...",
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_14622),
    c("function (...) ", "{", "    input <- list(...)", "    if (isTRUE(use_index)) {",
      "        input <- input %>% purrr::map(.f = ~{", "            seq_along(.x)",
      "        })", "    }", "    input %>% purrr::map(.f = function(x) {",
      "        negate_fn(round_fn(rlang::exec(.fn = fn, x, !!!args)))",
      "    }) %>% unlist(recursive = TRUE, use.names = FALSE)", "}"),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = TRUE, n...
  # Changed from baseline: round_fn = identity
  xpectr::set_test_seed(42)
  # Assigning output
  output_19400 <- create_n_fn(fn = median, use_index = TRUE, negate = FALSE, round_fn = identity)
  # Testing is function
  expect_true(
    is.function(output_19400))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_19400),
    "...",
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_19400),
    c("function (...) ", "{", "    input <- list(...)", "    if (isTRUE(use_index)) {",
      "        input <- input %>% purrr::map(.f = ~{", "            seq_along(.x)",
      "        })", "    }", "    input %>% purrr::map(.f = function(x) {",
      "        negate_fn(round_fn(rlang::exec(.fn = fn, x, !!!args)))",
      "    }) %>% unlist(recursive = TRUE, use.names = FALSE)", "}"),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = TRUE, n...
  # Changed from baseline: round_fn = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(create_n_fn(fn = median, use_index = TRUE, negate = FALSE, round_fn = 1), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'round_fn': Must be a function, not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = TRUE, n...
  # Changed from baseline: round_fn = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(create_n_fn(fn = median, use_index = TRUE, negate = FALSE, round_fn = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'round_fn': Must be a function, not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_n_fn(fn = median, use_index = TRUE, n...
  # Changed from baseline: round_fn = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(create_n_fn(fn = median, use_index = TRUE, negate = FALSE, round_fn = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'round_fn': Must be a function, not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'create_n_fn'                                           ####
  #

})

test_that("testing median_index()", {
  xpectr::set_test_seed(42)

  # Create three vectors
  x <- runif(10)
  y <- runif(10)
  z <- runif(10)

  # It shouldn't care about NAs, as it works on indices
  z[[1]] <- NA


  ## Testing 'median_index(x, y, z, negate = TRUE, na.rm =...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_17375 <- median_index(x, y, z, negate = TRUE, round_fn = floor)
  # Testing class
  expect_equal(
    class(output_17375),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17375,
    type = "double")
  # Testing values
  expect_equal(
    output_17375,
    c(-5, -5, -5),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_17375),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_17375),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_17375)),
    3L)
  ## Finished testing 'median_index(x, y, z, negate = TRUE, na.rm =...'     ####


  ## Testing 'median_index(x, y, z, negate = FALSE, na.rm ...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- median_index(x, y, z, negate = FALSE, round_fn = ceiling)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(6, 6, 6),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'median_index(x, y, z, negate = FALSE, na.rm ...'     ####


})

test_that("testing quantile_index()", {
  xpectr::set_test_seed(42)

  # Create three vectors
  x <- runif(10)
  y <- runif(10)
  z <- runif(10)

  # It shouldn't care about NAs, as it works on indices
  z[[1]] <- NA


  ## Testing 'quantile_index(x, y, z, prob = 0.2, type = 7...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_17375 <- quantile_index(x, y, z, prob = 0.2, type = 7, negate = TRUE, round_fn = ceiling)
  # Testing class
  expect_equal(
    class(output_17375),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17375,
    type = "double")
  # Testing values
  expect_equal(
    output_17375,
    c(-3, -3, -3),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_17375),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_17375),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_17375)),
    3L)
  ## Finished testing 'quantile_index(x, y, z, prob = 0.2, type = 7...'     ####



  ## Testing 'quantile_index(x, y, z, prob = 0.6, type = 7...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- quantile_index(x, y, z, prob = 0.6, type = 7, negate = FALSE, round_fn = ceiling)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(7, 7, 7),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'quantile_index(x, y, z, prob = 0.6, type = 7...'     ####


  ## Testing 'quantile_index(x, y, z, prob = 0.6, type = 7...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- quantile_index(x, y, z, prob = 0.6, type = 7, negate = FALSE, round_fn = floor)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(6, 6, 6),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'quantile_index(x, y, z, prob = 0.6, type = 7...'     ####



  ## Testing 'quantile_index(x, y, z, prob = 0.6, type = 4...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- quantile_index(x, y, z, prob = 0.6, type = 4, negate = FALSE, round_fn = ceiling)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(6, 6, 6),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    3L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    3L)
  ## Finished testing 'quantile_index(x, y, z, prob = 0.6, type = 4...'     ####



  ## Testing 'quantile_index(x, y, z, prob = -0.6, type = ...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(quantile_index(x, y, z, prob = -0.6, type = 10, negate = NA, round_fn = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("2 assertions failed:\n * Variable 'round_fn': Must be a function, not 'logical'.\n * Variable 'negate': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'quantile_index(x, y, z, prob = -0.6, type = ...'     ####


  ## Testing 'quantile_index(x, y, z, prob = -0.6, type = ...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(quantile_index(x, y, z, prob = -0.6, type = 10, negate = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'negate': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'quantile_index(x, y, z, prob = -0.6, type = ...'     ####



  ## Testing 'quantile_index(x, y, z, prob = -0.6, type = 10)'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(quantile_index(x, y, z, prob = -0.6, type = 10), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("'probs' outside [0,1]"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'quantile_index(x, y, z, prob = -0.6, type = 10)'     ####


  ## Testing 'quantile_index(x, y, z, prob = 0.6, type = 10)'               ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(quantile_index(x, y, z, prob = 0.6, type = 10), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error']]),
    xpectr::strip("object 'a' not found"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'quantile_index(x, y, z, prob = 0.6, type = 10)'      ####


})
