% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centering.R
\name{center_max}
\alias{center_max}
\title{Centers the highest value with values decreasing around it}
\usage{
center_max(data, col = NULL, shuffle_sides = FALSE)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{col}{Column to create sorting factor by. When \code{NULL} and \code{`data`} is a \code{data.frame},
the row numbers are used.}

\item{shuffle_sides}{Whether to shuffle which elements are left and right of the center. (Logical)}
}
\value{
The sorted \code{data.frame} (\code{tibble}) / \code{vector}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

The highest value is positioned in the middle with the other
values decreasing around it.

\strong{Example}:

The column values:

\code{c(1, 2, 3, 4,} \strong{\code{5}}\code{)}

are \strong{ordered as}:

\code{c(1, 3,} \strong{\code{5}}\code{, 4, 2)}
}
\examples{
# Attach packages
library(rearrr)
library(dplyr)

# Set seed
set.seed(1)

# Create a data frame
df <- data.frame(
  "index" = 1:10,
  "A" = sample(1:10),
  "B" = runif(10),
  "C" = LETTERS[1:10],
  "G" = c(
    1, 1, 1, 2, 2,
    2, 3, 3, 3, 3
  ),
  stringsAsFactors = FALSE
)

# Center by the index (row numbers)
center_max(df)

# Center by each of the columns
center_max(df, col = "A")
center_max(df, col = "B")
center_max(df, col = "C")

# Randomize which elements are left and right of the center
center_max(df, col = "A", shuffle_sides = TRUE)

# Grouped by G
df \%>\%
  dplyr::select(G, A) \%>\% # For clarity
  dplyr::group_by(G) \%>\%
  center_max(col = "A")

# Plot the centered values
plot(x = 1:10, y = center_max(df, col = "B")$B)
plot(x = 1:10, y = center_max(df, col = "B", shuffle_sides = TRUE)$B)
}
\seealso{
Other rearrange functions: 
\code{\link{center_min}()},
\code{\link{closest_to}()},
\code{\link{furthest_from}()},
\code{\link{pair_extremes}()},
\code{\link{position_max}()},
\code{\link{position_min}()},
\code{\link{rev_windows}()},
\code{\link{roll_elements}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{rearrange functions}
