% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk.R, R/deprecated.R
\name{chk_sqlite_conn}
\alias{chk_sqlite_conn}
\alias{check_sqlite_connection}
\title{Check SQLite Connection}
\usage{
chk_sqlite_conn(x, connected = NA, x_name = NULL)

check_sqlite_connection(
  x,
  connected = NA,
  x_name = substitute(x),
  error = TRUE
)
}
\arguments{
\item{x}{The object to check.}

\item{connected}{A logical scalar specifying whether x should be connected.}

\item{x_name}{A string of the name of object x or NULL.}

\item{error}{A flag specifying whether to through an error if the check fails.}
}
\value{
\code{NULL}, invisibly. Called for the side effect of throwing an error
if the condition is not met.
}
\description{
\code{chk_sqlite_conn}
checks if a SQLite connection.
}
\section{Functions}{
\itemize{
\item \code{check_sqlite_connection()}: Check SQLite Connection

}}
\examples{
conn <- rws_connect()
chk_sqlite_conn(conn)
rws_disconnect(conn)
try(chk_sqlite_conn(conn, connected = TRUE))
}
