% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/reader.R
\name{classify.ext}
\alias{classify.ext}
\title{Classify file types readable by standard R I/O functions.}
\usage{
classify.ext(ext = NULL, more.txt = NULL, more.bin = NULL,
  more.csv = NULL, print.all = FALSE)
}
\arguments{
\item{ext}{filenames or extensions to classify}

\item{more.txt}{more extensions that should be treated as txt}

\item{more.bin}{more extensions that should be treated as binary}

\item{more.csv}{more extensions that should be treated as csv}

\item{print.all}{setting to T, simply prints the list of supported ext}
}
\value{
returns the 4 way classification for each file/extension
}
\description{
Look for known file extensions and classify as binary, comma-separated,
text format, or OTH=other; other files are assumed to be unreadable.
To read other files, need to specify more types manually.
}
\examples{
classify.ext(c("test.txt","*.csv","tot","other","rda","test.RDatA"))
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
\seealso{
\code{\link{get.delim}}
}

