% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readJDX.R
\name{readJDX}
\alias{readJDX}
\title{Import a File Written in the JCAMP-DX Format}
\usage{
readJDX(file = "", SOFC = TRUE, debug = 0)
}
\arguments{
\item{file}{Character.  The file name to import.}

\item{SOFC}{Logical.  "Stop on Failed Check" The JCAMP-DX standard requires
several checks of the data as it is decompressed.  These checks are essential
to obtaining the correct results.  However, some JCAMP-DX writing programs
do not follow the standard to the letter (for instance we have observed that
not all writers put FIRSTY into the metadata, even though it is required by
the standard).
This option is provided for those \pkg{advanced
users} who have carefully checked their original files and want to skip the 
required checks.  It may also be useful for troubleshooting.  
The default is \code{TRUE} i.e. stop when something is not right.
This ensures that correct data is returned.  Change to \code{FALSE} at your own risk.
NOTE: Only a few checks can be skipped via this option, as there are some
parameters that must be available in order to return an answer.}

\item{debug}{Integer.  The level of debug reporting desired. 1
or higher = basic info about
each file, and import progress.  2 = detailed info about x values.
3 = detailed info about y values. 4 = details about the DUP expansion
process. 5 = details about the calculation of differences when DIF
is in use.
In cases where an error is about to
stop execution, you get additional information regardless of
the \code{debug} value.}
}
\value{
A list.  The first element is the file metadata.  Additional elements
contain the extracted \code{x,y} data in one or more data frames as follows.
If the file contains multiple spectra
(not currently supported), there will be one data frame for each spectrum.
If the file contains the real and imaginary
parts of a 1D NMR spectrum, there will be two data frames, one containing the real portion
and the other the imaginary portion.  If the file contains one non-NMR spectrum,
a single data frame will be returned.  In all cases the data frame has
elements \code{x} and \code{y}.
}
\description{
This is the function users should call, and supervises the entire import process.
The JCAMP-DX standard allows quite a bit of lattitude and there are many
possible formats. Not all possible formats are supported; error messages will
generally let you know what's going on.  If you have a file that you feel should be
supported but gives an error, please file an issue at Github.
The standard allows many
variations and its impossible to test them all.
}
\section{Included Data Files}{

The examples make use of data files included with the package. File \code{SBO.jdx}
is an IR spectrum of Smart Balance Original spread (a butter substitute). The
spectrum is presented in transmission format, and was recorded on a ThermoFisher
instrument.  The file uses AFFN compression, and was written
with the JCAMP-DX 5.01 standard. Note that even though the y-axis is in 
percent transmission, in the JDX file it is stored on [0\ldots1].
File \code{PCRF.jdx} is a 1H NMR
spectrum of a hexane extract of a reduced fat potato chip.  The spectrum was
recorded on a JEOL instrument.  The file uses SQZ DIF compression, and was written
with the JCAMP-DX 6.00 standard.
File \code{PCRF_line265.jdx} has a deliberate error in it.  See the examples.
}

\section{Precision}{

Internally, this package uses a tolerance factor when comparing values during certain checks.
This is currently hardwired to \code{0.0001*diff(range(values))}.  This value works fine
in the test files.
This appears to be necessary because the original values in the files
are text strings of varying lengths which get converted to numerical values.  Some precision
may be lost but it appears trivial with the current settings.
}
\examples{
sbo <- system.file("extdata", "SBO.jdx", package = "readJDX")
chk <- readJDX(sbo)
plot(chk[[2]]$x, chk[[2]]$y/100, type = "l", main = "Original Smart Balance Spread",
	xlab = "wavenumber", ylab = "Percent Transmission")

pcrf <- system.file("extdata", "PCRF.jdx", package = "readJDX")
chk <- readJDX(pcrf)
plot(chk[[2]]$x, chk[[2]]$y, type = "l", main = "Reduced Fat Potato Chip Extract",
	xlab = "ppm", ylab = "Intensity")

\dontrun{
# Line 265 has an N -> G typo.  Try with various levels of debug.
# Even with debug = 0 you get useful diagnostic info.
problem <- system.file("extdata", "PCRF_line265.jdx", package = "readJDX")
chk <- readJDX(problem)
}

}
\seealso{
Do \code{browseVignettes("readJCAMPDX")} for background information,
references and supported formats.
}

