% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pos_neg_colors.R
\name{pos_neg_colors}
\alias{pos_neg_colors}
\title{Assign colors to negative and positive values}
\usage{
pos_neg_colors(neg_col, pos_col, bold = NULL)
}
\arguments{
\item{neg_col}{color to assign to negative values.}

\item{pos_col}{color to assign to positive values.}

\item{bold}{optional argument to bold values.
Default is set to NULL or not bold.}
}
\value{
a function that applies a color
    to the positive and negative values of numeric column.
}
\description{
The `pos_neg_colors()` function assigns a color to all negative values and a color to all positive values.
    It should be placed within the style argument in reactable::colDef.
}
\examples{
data <- data.frame(
Symbol = c("GOOG", "FB", "AMZN", "NFLX", "TSLA"),
Price = c(1265.13, 187.89, 1761.33, 276.82, 328.13),
Change = c(4.14, 1.51, -19.45, 5.32, -12.45))

## Assign the color red to negative values and green to positive values
reactable(data,
columns = list(
Change = colDef(
style = pos_neg_colors("red", "green"))))

## Bold values
reactable(data,
columns = list(
Change = colDef(
style = pos_neg_colors("red", "green", bold = TRUE))))

}
