% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaffold.R
\name{scaffoldReactWidget}
\alias{scaffoldReactWidget}
\title{Create implementation scaffolding for a React.js-based HTML widget}
\usage{
scaffoldReactWidget(name, npmPkg = NULL, edit = interactive())
}
\arguments{
\item{name}{Name of widget}

\item{npmPkg}{Optional \href{https://npmjs.com/}{NPM} package upon which this
widget is based, a named list with two elements: \code{name} and
\href{https://docs.npmjs.com/files/package.json#dependencies}{version}. If
you specify this parameter the package will be added to the
\code{dependency} section of the generated \code{package.json}.}

\item{edit}{Automatically open the widget's JavaScript source file after
creating the scaffolding.}
}
\description{
Add the minimal code required to implement a React.js-based HTML widget to an
R package.
}
\note{
This function must be executed from the root directory of the package
  you wish to add the widget to.
}
