% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotRate}
\alias{plotRate}
\title{Plotting the Baseline Cumulative Rate Function for the Recurrent Event Process}
\usage{
plotRate(
  x,
  type = c("unrestricted", "scaled", "raw"),
  smooth = FALSE,
  control = list(),
  ...
)
}
\arguments{
\item{x}{an object of class \code{reReg}, usually returned by the \code{reReg} function.}

\item{type}{a character string specifying the type of rate function to be plotted.
Options are "unrestricted", "scaled", "raw". See \bold{Details}.}

\item{smooth}{an optional logical value indicating whether to add a smooth curve obtained from a monotone increasing P-splines implemented in package \code{scam}.}

\item{control}{a list of control parameters.}

\item{...}{graphical parameters to be passed to methods.
These include \code{xlab}, \code{ylab}, \code{main}, and more. See \bold{Details}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the baseline rate function for an \code{reReg} object.
}
\details{
The \code{plotRate()} plots the estimated baseline cumulative rate function 
depending on the identifiability assumption.
When \code{type = "unrestricted"} (default), the baseline cumulative rate function
is plotted under the assumption \eqn{E(Z) = 1}.
When \code{type = "scaled"}, the baseline cumulative rate function is plotted
under the assumption \eqn{\Lambda(\min(Y^\ast, \tau)) = 1}.
When \code{type = "raw"}, the baseline cumulative rate function is plotted
under the assumption \eqn{\Lambda(\tau) = 1}.
See \code{?reReg} for the specification of the notations and underlying models.

The argument \code{control} consists of options with argument defaults
to a list with the following values:
\describe{
  \item{xlab}{customizable x-label, default value is "Time".}
  \item{ylab}{customizable y-label, default value is empty.}
  \item{main}{customizable title, default value is "Baseline cumulative rate function".}
}
These arguments can also be passed down without specifying a \code{control} list. See \bold{Examples}.
}
\examples{
data(simDat)
fm <- Recur(Time, id, event, status) ~ x1 + x2

fit <- reReg(fm, data = simDat, method = "cox", B = 0)
## Plot both the baseline cumulative rate and hazard function
plot(fit)
## Plot baseline cumulative rate function
plotRate(fit)
plotRate(fit, smooth = TRUE)
}
\seealso{
\code{\link{reReg}} \code{\link{plot.reReg}}
}
\keyword{Plots}
