% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotHaz}
\alias{plotHaz}
\title{Plotting the baseline hazard function}
\usage{
plotHaz(x, control = list(), ...)
}
\arguments{
\item{x}{an object of class \code{reReg}, usually returned by the \code{reReg} function.}

\item{control}{a list of control parameters.}

\item{...}{for future developments.}
}
\description{
Plot the baseline hazard function after fitting \code{reReg}.
}
\details{
The argument \code{control} consists of options with argument defaults to a list with the following values:
\describe{
  \item{xlab}{customizable x-label, default value is "Time".}
  \item{ylab}{customizable y-label, default value is "Subject".}
  \item{title}{customizable title, default value is "Recurrent event plot".}
}
}
\examples{
## readmission data
data(readmission)
set.seed(123)
fit <- reReg(reSurv(t.stop, event, death, id) ~ sex + chemo,
             data = subset(readmission, id < 50),
             method = "am.XCHWY", se = "resampling", B = 20)
## Plot both the baseline cumulative rate and hazard function
plot(fit)
## Plot baseline cumulative hazard function
plotHaz(fit)
## Plot with user-specified labels
plotHaz(fit, control = list(xlab = "User xlab", ylab = "User ylab", title = "User title"))  
}
\seealso{
\code{\link{reReg}}
}
