% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_deps.R
\name{add_deps}
\alias{add_deps}
\title{Add required dependencies to the description file}
\usage{
add_deps()
}
\value{
No return value.
}
\description{
This function detects external packages used in an R project (package,
compendium, website, etc.) and updates the sections \strong{Depends},
\strong{Imports}, and \strong{Suggests} of the \code{DESCRIPTION} file.

A \code{DESCRIPTION} file can be created and added to an existing project with
the function \code{\link[usethis:use_description]{usethis::use_description()}}.

All \code{.R}, \code{.Rmd}, and \code{.qmd} files are screened to identify packages
called by \code{library(foo)}, \code{library("foo")}, \code{library('foo')},
\code{require(foo)}, \code{require("foo")}, \code{require('foo')} or \code{foo::bar()}.

Different types of dependencies are handled with the following rules:
\itemize{
\item if a package is called with \code{library(foo)} or \code{require(foo)},
it will be added to the section \strong{Depends} of the \code{DESCRIPTION} file
(except for vignettes and tests);
\item if the package is called with \code{foo::bar()},
it will be added to the section \strong{Imports} of the \code{DESCRIPTION} file
(except for vignettes and tests);
\item if the package is only used in vignettes or tests,
it will be added to the section \strong{Suggests} of the \code{DESCRIPTION} file.
}

This function also screens the \code{NAMESPACE} file (it detects packages
mentioned as \code{import(foo)} and \code{importFrom(foo,bar)}) and \verb{@examples}
sections of \code{roxygen2} headers. The detected packages are added in the
\strong{Imports} section of the \code{DESCRIPTION} file.

If the project is not an R package, non-standard folders are also screened
(i.e. \verb{analyses/}, \verb{paper/}, etc.). The detected packages are added in the
\strong{Imports} section of the \code{DESCRIPTION} file.
}
\examples{
\dontrun{
add_deps()
}
}
