% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPDataFrame.R
\name{healpixCentered}
\alias{healpixCentered}
\title{Check if object is assumed to have HEALPix centered coordinates}
\usage{
healpixCentered(obj)
}
\arguments{
\item{obj}{Any object.}
}
\value{
A boolean. This is \code{TRUE} if \code{obj}
is a \code{\link{CMBDataFrame}} or a \code{\link{HPDataFrame}} whose
coordinates were assumed to correspond to HEALPix pixel center
locations.
}
\description{
The function checks object's attribute healpixCentered. The attribute is
\code{TRUE} if the  object was assumed to have rows that correspond to
unique HEALPix pixel indices.
}
\examples{

hp1 <- HPDataFrame(I=rnorm(5), nside = 1, spix = c(1,1,2,2,3))
pix(hp1)
coords(hp1, new.coords = "cartesian")
healpixCentered(hp1)

sky <- CMBDataFrame(nside = 32, coords = "cartesian", ordering = "nested")
sky.s <- CMBDataFrame(sky, sample.size = 100)
hpdf <- HPDataFrame(sky.s, auto.spix = TRUE)
healpixCentered(hpdf)

}
