% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MathHelpers.R
\name{sphericalHarmonics}
\alias{sphericalHarmonics}
\title{Compute spherical harmonic values at given points on the sphere.}
\usage{
sphericalHarmonics(L, m, xyz)
}
\arguments{
\item{L}{The degree of spherical harmonic (L=0,1,2,...)}

\item{m}{The order number of the degree-L spherical
harmonic (m=-L,-L+1,...,L-1,L)}

\item{xyz}{Dataframe for given points in 3D cartesian coordinates}
}
\value{
values of spherical harmonics
}
\description{
The function \code{sphericalHarmonics} computes
the spherical harmonic values
for the given 3D Cartesian coordinates.
}
\examples{
## Calculate spherical harmonic value at
## the point (0,1,0) with L=5, m=2
point<-data.frame(x=0,y=1,z=0)
sphericalHarmonics(5,2,point)

## Calculate spherical harmonic values at
## the point (1,0,0), (0,1,0), (0,0,1) with L=5, m=2
points<-data.frame(diag(3))
sphericalHarmonics(5,2,points)

}
\references{
See
https://en.wikipedia.org/wiki/Table_of_spherical_harmonics

It uses equation (7) in Hesse, K., Sloan, I. H., &
Womersley, R. S. (2010).
Numerical integration on the sphere.
In Handbook of Geomathematics (pp. 1185-1219).
Springer Berlin Heidelberg,

but instead of the order k=1,...,2L+1 in the book we use m=k-L-1.
}
