% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cramerV.r
\name{cramerV}
\alias{cramerV}
\title{Cramer's V (phi)}
\usage{
cramerV(
  x,
  y = NULL,
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 4,
  bias.correct = FALSE,
  reportIncomplete = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{Either a two-way table or a two-way matrix.
Can also be a vector of observations for one dimension
of a two-way table.}

\item{y}{If \code{x} is a vector, \code{y} is the vector of observations for
the second dimension of a two-way table.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{bias.correct}{If \code{TRUE}, a bias correction is applied.}

\item{reportIncomplete}{If \code{FALSE} (the default),
\code{NA} will be reported in cases where there
are instances of the calculation of the statistic
failing during the bootstrap procedure.}

\item{verbose}{If \code{TRUE}, prints additional statistics.}

\item{...}{Additional arguments passed to \code{chisq.test}.}
}
\value{
A single statistic, Cramer's V.  
        Or a small data frame consisting of Cramer's V,
        and the lower and upper confidence limits.
}
\description{
Calculates Cramer's V for a table of nominal variables;
             confidence intervals by bootstrap.
}
\details{
Cramer's V is used as a measure of association
          between two nominal variables, or as an effect size
          for a chi-square test of association.  For a 2 x 2 table,
          the absolute value of the phi statistic is the same as
          Cramer's V.
          
          Because V is always positive, if \code{type="perc"},
          the confidence interval will
          never cross zero. In this case, 
          the confidence interval range should not
          be used for statistical inference.
          However, if \code{type="norm"}, the confidence interval
          may cross zero.  
          
          When V is close to 0 or very large,
          or with small counts, 
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
### Example with table
data(Anderson)
fisher.test(Anderson)
cramerV(Anderson)

### Example with two vectors
Species = c(rep("Species1", 16), rep("Species2", 16))
Color   = c(rep(c("blue", "blue", "blue", "green"),4),
            rep(c("green", "green", "green", "blue"),4))
fisher.test(Species, Color)
cramerV(Species, Color)

}
\references{
\url{http://rcompanion.org/handbook/H_10.html}
}
\seealso{
\code{\link{cohenW}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{correlation phi cramer V}
