% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohenG.r
\name{cohenG}
\alias{cohenG}
\title{Cohen's g and odds ratio for paired contingency tables}
\usage{
cohenG(x, ci = FALSE, conf = 0.95, type = "perc", R = 1000,
  histogram = FALSE, digits = 3)
}
\arguments{
\item{x}{A two-way contingency table. It must be square. 
It can have two or
more levels for each dimension.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}
}
\value{
A list containing: a data frame of results of the global statistics;
        and a data frame of results of the pairwise statistics.
}
\description{
Calculates Cohen's g and odds ratio
             for paired contingency tables, such as those that 
             might be analyzed with   
             McNemar or McNemar-Bowker tests.
}
\details{
For a 2 x 2 table, where a and d are the concordant cells
         and b and c are discordant cells:
         Odds ratio is b/c;
         P is b/(b+c);
         and Cohen's g is P - 0.5.
         
         In the 2 x 2 case, the statistics are directional.
         That is, when cell [1, 2] in the table is greater than
         cell [2, 1], OR is greater than 1, P is greater than 0.5,
         and g is positive.  
         
         In the opposite case, OR is less than 1,
         P is less than 0.5, and g is negative.
         
         In the 2 x 2 case, when the effect is small, the
         confidence interval for OR can pass through 1,
         for g can pass through 0, and for P can pass through 0.5.
         
         For tables larger than 2 x 2, the statistics are not directional.
         That is, OR is always >= 1, P is always >= 0.5, and
         g is always positive.  
         Because of this, the confidence interval will
         never cross the values for no effect 
         (OR = 1, P = 0.5, or g = 0).
         Because of this, the confidence interval range should not
         be used for statistical inference for tables larger than 2 x 2. 
         
          When the reported statistics are close to their extremes,
          or with small counts, 
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
### 2 x 2 repeated matrix example
data(AndersonRainBarrel)
cohenG(AndersonRainBarrel)
                    
### 3 x 3 repeated matrix
data(AndersonRainGarden)
cohenG(AndersonRainGarden)

}
\references{
\url{http://rcompanion.org/handbook/H_05.html}
}
\seealso{
\code{\link{nominalSymmetryTest}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Effect size Cohen g McNemar Bowker contingency symmetry nominal}
