/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.stml.attribute;

import java.text.ParseException;
import nu.xom.Attribute;
import org.xmlcml.euclid.Util;
import org.xmlcml.stml.STMLAttribute;

public class DoubleSTAttribute
extends STMLAttribute {
    public static final String JAVA_TYPE = "double";
    public static final String JAVA_GET_METHOD = "getDouble";
    public static final String JAVA_SHORT_CLASS = "DoubleSTAttribute";
    protected Double d;

    public DoubleSTAttribute(String name) {
        super(name);
    }

    public DoubleSTAttribute(Attribute att) {
        this(att.getLocalName());
        String v = att.getValue();
        if (v != null && !v.trim().equals("")) {
            this.setSTMLValue(v);
        }
    }

    public DoubleSTAttribute(Attribute att, String value) {
        super(att, value.trim());
    }

    public DoubleSTAttribute(DoubleSTAttribute att) {
        super(att);
        if (att.d != null) {
            this.d = new Double(att.d);
        }
    }

    @Override
    public Attribute copy() {
        return new DoubleSTAttribute(this);
    }

    @Override
    public String getJavaType() {
        return JAVA_TYPE;
    }

    @Override
    public void setSTMLValue(String s) {
        if (s != null && !s.trim().equals("")) {
            double d;
            try {
                String ss = s.trim();
                if (ss.startsWith("+")) {
                    ss = ss.substring(1);
                }
                d = Util.parseFlexibleDouble(ss);
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("" + nfe, nfe);
            }
            catch (ParseException e) {
                throw new RuntimeException("Bad double: " + s.trim(), e);
            }
            this.setSTMLValue(d);
        }
    }

    public void checkValue(double d) throws RuntimeException {
        if (this.cmlType != null) {
            this.cmlType.checkValue(d);
        }
    }

    public void setSTMLValue(double d) {
        this.checkValue(d);
        this.d = new Double(d);
        this.setValue("" + d);
    }

    public double getDouble() {
        return this.d;
    }

    @Override
    public String getJavaGetMethod() {
        return JAVA_GET_METHOD;
    }

    @Override
    public String getJavaShortClassName() {
        return JAVA_SHORT_CLASS;
    }
}

