/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.qsar.result.IntegerResultType;

public class SpiroAtomCountDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"nSpiroAtoms"};

    public void initialise(IChemObjectBuilder builder) {
    }

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#nSpiroAtom", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    private static void traverseRings(IAtomContainer mol, IAtom atom, IBond prev) {
        atom.setFlag(16, true);
        prev.setFlag(16, true);
        for (IBond bond : mol.getConnectedBondsList(atom)) {
            IAtom nbr = bond.getOther(atom);
            if (!nbr.getFlag(16)) {
                SpiroAtomCountDescriptor.traverseRings(mol, nbr, bond);
                continue;
            }
            bond.setFlag(16, true);
        }
    }

    private static int getSpiroDegree(IAtomContainer mol, IAtom atom) {
        if (!atom.isInRing()) {
            return 0;
        }
        ArrayList<IBond> rbonds = new ArrayList<IBond>(4);
        for (IBond bond : mol.getConnectedBondsList(atom)) {
            if (!bond.isInRing()) continue;
            rbonds.add(bond);
        }
        if (rbonds.size() < 4) {
            return 0;
        }
        int degree = 0;
        for (IBond b : mol.bonds()) {
            b.setFlag(16, false);
        }
        for (IAtom a : mol.atoms()) {
            a.setFlag(16, false);
        }
        atom.setFlag(16, true);
        for (IBond rbond : rbonds) {
            if (rbond.getFlag(16)) continue;
            SpiroAtomCountDescriptor.traverseRings(mol, rbond.getOther(atom), rbond);
            ++degree;
        }
        return degree < 2 ? 0 : degree;
    }

    public DescriptorValue calculate(IAtomContainer atomContainer) {
        int nSpiro = 0;
        try {
            IAtomContainer local = atomContainer.clone();
            Cycles.markRingAtomsAndBonds((IAtomContainer)local);
            for (IAtom atom : local.atoms()) {
                if (SpiroAtomCountDescriptor.getSpiroDegree(local, atom) == 0) continue;
                ++nSpiro;
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(nSpiro), this.getDescriptorNames());
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
    }

    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResultType();
    }

    public String[] getParameterNames() {
        return new String[0];
    }

    public Object getParameterType(String name) {
        return null;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(-1), this.getDescriptorNames(), exception);
    }
}

