/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

public class MDLFormat
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new MDLFormat();
        }
        return myself;
    }

    @Override
    public String getFormatName() {
        return "MDL Molfile";
    }

    @Override
    public String getMIMEType() {
        return "chemical/x-mdl-molfile";
    }

    @Override
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @Override
    public String[] getNameExtensions() {
        return new String[]{"mol"};
    }

    @Override
    public String getReaderClassName() {
        return "org.openscience.cdk.io.MDLReader";
    }

    @Override
    public String getWriterClassName() {
        return null;
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        if (lineNumber == 4 && line.length() > 7 && !line.contains("2000") && !line.contains("3000")) {
            try {
                String atomCountString = line.substring(0, 3).trim();
                String bondCountString = line.substring(3, 6).trim();
                Integer.valueOf(atomCountString);
                Integer.valueOf(bondCountString);
                String remainder = line.substring(6).trim();
                for (int i = 0; i < remainder.length(); ++i) {
                    char c = remainder.charAt(i);
                    if (Character.isDigit(c) || Character.isWhitespace(c)) continue;
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isXMLBased() {
        return false;
    }

    @Override
    public int getSupportedDataFeatures() {
        return this.getRequiredDataFeatures() | 1 | 2 | 0x200;
    }

    @Override
    public int getRequiredDataFeatures() {
        return 8;
    }
}

