/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

public class BondCountDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private String order = "";

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#bondCount", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("BondCount only expects one parameter");
        }
        if (!(params[0] instanceof String)) {
            throw new CDKException("The parameter must be of type IBond.Order");
        }
        String bondType = (String)params[0];
        if (bondType.length() > 1 || !"sdtq".contains(bondType)) {
            throw new CDKException("The only allowed values for this parameter are 's', 'd', 't', 'q' and ''.");
        }
        this.order = bondType;
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.order};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        if (this.order.equals("")) {
            return new String[]{"nB"};
        }
        return new String[]{"nB" + this.order};
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container) {
        if (this.order.equals("")) {
            int bondCount = 0;
            for (IBond bond : container.bonds()) {
                boolean hasHydrogen = false;
                for (int i = 0; i < bond.getAtomCount(); ++i) {
                    if (!bond.getAtom(i).getSymbol().equals("H")) continue;
                    hasHydrogen = true;
                    break;
                }
                if (hasHydrogen) continue;
                ++bondCount;
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(bondCount), this.getDescriptorNames(), null);
        }
        int bondCount = 0;
        for (IBond bond : container.bonds()) {
            if (!this.bondMatch(bond.getOrder(), this.order)) continue;
            ++bondCount;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(bondCount), this.getDescriptorNames());
    }

    private boolean bondMatch(IBond.Order order, String orderString) {
        if (order == IBond.Order.SINGLE && "s".equals(orderString)) {
            return true;
        }
        if (order == IBond.Order.DOUBLE && "d".equals(orderString)) {
            return true;
        }
        if (order == IBond.Order.TRIPLE && "t".equals(orderString)) {
            return true;
        }
        return order == IBond.Order.QUADRUPLE && "q".equals(orderString);
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"order"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        if ("order".equals(name)) {
            return "";
        }
        return null;
    }
}

