/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ArrowElement;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;

@TestClass(value="org.openscience.cdk.renderer.generators.ReactionArrowGeneratorTest")
public class ReactionArrowGenerator
implements IGenerator<IReaction> {
    @TestMethod(value="testEmptyReaction")
    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        Rectangle2D totalBoundsReactants = BoundsCalculator.calculateBounds((IAtomContainerSet)reaction.getReactants());
        Rectangle2D totalBoundsProducts = BoundsCalculator.calculateBounds((IAtomContainerSet)reaction.getProducts());
        if (totalBoundsReactants == null || totalBoundsProducts == null) {
            return null;
        }
        double separation = (Double)((BasicSceneGenerator.BondLength)model.getParameter(BasicSceneGenerator.BondLength.class)).getValue() / (Double)((BasicSceneGenerator.Scale)model.getParameter(BasicSceneGenerator.Scale.class)).getValue();
        Color foregroundColor = (Color)((BasicSceneGenerator.ForegroundColor)model.getParameter(BasicSceneGenerator.ForegroundColor.class)).getValue();
        return new ArrowElement(totalBoundsReactants.getMaxX() + separation, totalBoundsReactants.getCenterY(), totalBoundsProducts.getMinX() - separation, totalBoundsReactants.getCenterY(), 1.0 / (Double)((BasicSceneGenerator.Scale)model.getParameter(BasicSceneGenerator.Scale.class)).getValue(), true, foregroundColor);
    }

    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(new IGeneratorParameter[0]);
    }
}

