/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.dict;

import java.io.IOException;
import java.io.Reader;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.dict.Dictionary;
import org.openscience.cdk.dict.Entry;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.dict.OWLFileTest")
public class OWLFile
extends Dictionary {
    private static String rdfNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static String rdfsNS = "http://www.w3.org/2000/01/rdf-schema#";

    public static Dictionary unmarshal(Reader reader) {
        ILoggingTool logger = LoggingToolFactory.createLoggingTool(OWLFile.class);
        OWLFile dict = new OWLFile();
        try {
            Builder parser = new Builder();
            Document doc = parser.build(reader);
            Element root = doc.getRootElement();
            logger.debug((Object)"Found root element: ", new Object[]{root.getQualifiedName()});
            String ownNS = root.getBaseURI();
            dict.setNS(ownNS);
            logger.debug((Object)"Found ontology namespace: ", new Object[]{ownNS});
            Elements entries = root.getChildElements();
            logger.info((Object)"Found #elements in OWL dict:", new Object[]{entries.size()});
            for (int i = 0; i < entries.size(); ++i) {
                Element entry = entries.get(i);
                if (entry.getNamespaceURI().equals(ownNS)) {
                    Entry dbEntry = OWLFile.unmarshal(entry, ownNS);
                    dict.addEntry(dbEntry);
                    logger.debug((Object)"Added entry: ", new Object[]{dbEntry});
                    continue;
                }
                logger.debug((Object)"Found a non-fact: ", new Object[]{entry.getQualifiedName()});
            }
        }
        catch (ParsingException ex) {
            logger.error((Object)"Dictionary is not well-formed: ", new Object[]{ex.getMessage()});
            logger.debug((Object)("Error at line " + ex.getLineNumber()), new Object[]{", column " + ex.getColumnNumber()});
            dict = null;
        }
        catch (IOException ex) {
            logger.error((Object)"Due to an IOException, the parser could not check:", new Object[]{ex.getMessage()});
            logger.debug((Object)ex);
            dict = null;
        }
        return dict;
    }

    public static Entry unmarshal(Element entry, String ownNS) {
        Element description;
        ILoggingTool logger = LoggingToolFactory.createLoggingTool(OWLFile.class);
        Attribute id = entry.getAttribute("ID", rdfNS);
        logger.debug((Object)"ID: ", new Object[]{id});
        Entry dbEntry = new Entry(id.getValue());
        Element label = entry.getFirstChildElement("label", rdfsNS);
        logger.debug((Object)"label: ", new Object[]{label});
        if (label != null) {
            dbEntry.setLabel(label.getValue());
        }
        dbEntry.setClassName(entry.getQualifiedName());
        logger.debug((Object)"class name: ", new Object[]{dbEntry.getClassName()});
        Element definition = entry.getFirstChildElement("definition", ownNS);
        if (definition != null) {
            dbEntry.setDefinition(definition.getValue());
        }
        if ((description = entry.getFirstChildElement("description", ownNS)) != null) {
            dbEntry.setDescription(description.getValue());
        }
        if (entry.getQualifiedName().equals("Descriptor")) {
            dbEntry.setRawContent(entry);
        }
        return dbEntry;
    }
}

