/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.IDeduceBondOrderTool;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.IValencyChecker;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class SmilesValencyChecker
implements IValencyChecker,
IDeduceBondOrderTool {
    private String atomTypeList = null;
    protected AtomTypeFactory structgenATF;
    protected static ILoggingTool logger = LoggingToolFactory.createLoggingTool(SmilesValencyChecker.class);

    public SmilesValencyChecker() {
        this("org/openscience/cdk/dict/data/cdk-atom-types.owl");
    }

    public SmilesValencyChecker(String atomTypeList) {
        this.atomTypeList = atomTypeList;
        logger.info((Object)"Using configuration file: ", new Object[]{atomTypeList});
    }

    @Override
    public void saturate(IAtomContainer atomContainer) throws CDKException {
        logger.info((Object)"Saturating atomContainer by adjusting bond orders...");
        boolean allSaturated = this.allSaturated(atomContainer);
        if (!allSaturated) {
            logger.info((Object)"Saturating bond orders is needed...");
            IBond[] bonds = new IBond[atomContainer.getBondCount()];
            for (int i = 0; i < bonds.length; ++i) {
                bonds[i] = atomContainer.getBond(i);
            }
            boolean succeeded = this.saturate(bonds, atomContainer);
            if (!succeeded) {
                throw new CDKException("Could not saturate this atomContainer!");
            }
        }
    }

    public boolean saturate(IBond[] bonds, IAtomContainer atomContainer) throws CDKException {
        logger.debug((Object)"Saturating bond set of size: ", new Object[]{bonds.length});
        boolean bondsAreFullySaturated = false;
        if (bonds.length > 0) {
            IBond bond = bonds[0];
            int leftBondCount = bonds.length - 1;
            IBond[] leftBonds = new IBond[leftBondCount];
            System.arraycopy(bonds, 1, leftBonds, 0, leftBondCount);
            logger.debug((Object)"Examining this bond: ", new Object[]{bond});
            if (this.isSaturated(bond, atomContainer)) {
                logger.debug((Object)"OK, bond is saturated, now try to saturate remaining bonds (if needed)");
                bondsAreFullySaturated = this.saturate(leftBonds, atomContainer);
            } else if (this.isUnsaturated(bond, atomContainer)) {
                logger.debug((Object)"Ok, this bond is unsaturated, and can be saturated");
                logger.debug((Object)"Option 1: Saturating this bond directly, then trying to saturate rest");
                boolean bondOrderIncreased = this.saturateByIncreasingBondOrder(bond, atomContainer);
                boolean bl = bondsAreFullySaturated = bondOrderIncreased && this.saturate(bonds, atomContainer);
                if (bondsAreFullySaturated) {
                    logger.debug((Object)"Option 1: worked");
                } else {
                    logger.debug((Object)"Option 1: failed. Trying option 2.");
                    logger.debug((Object)"Option 2: Saturing this bond by saturating the rest");
                    if (bondOrderIncreased) {
                        this.unsaturateByDecreasingBondOrder(bond);
                    }
                    boolean bl2 = bondsAreFullySaturated = this.saturate(leftBonds, atomContainer) && this.isSaturated(bond, atomContainer);
                    if (!bondsAreFullySaturated) {
                        logger.debug((Object)"Option 2: failed");
                    }
                }
            } else {
                logger.debug((Object)"Ok, this bond is unsaturated, but cannot be saturated");
                bondsAreFullySaturated = this.saturate(leftBonds, atomContainer) && this.isSaturated(bond, atomContainer);
            }
        } else {
            bondsAreFullySaturated = true;
        }
        return bondsAreFullySaturated;
    }

    public boolean unsaturateByDecreasingBondOrder(IBond bond) {
        if (bond.getOrder() != IBond.Order.SINGLE) {
            bond.setOrder(BondManipulator.decreaseBondOrder((IBond.Order)bond.getOrder()));
            return true;
        }
        return false;
    }

    public boolean isUnsaturated(IBond bond, IAtomContainer atomContainer) throws CDKException {
        logger.debug((Object)"isBondUnsaturated?: ", new Object[]{bond});
        IAtom[] atoms = BondManipulator.getAtomArray((IBond)bond);
        boolean isUnsaturated = true;
        for (int i = 0; i < atoms.length && isUnsaturated; ++i) {
            isUnsaturated = isUnsaturated && !this.isSaturated(atoms[i], atomContainer);
        }
        logger.debug((Object)"Bond is unsaturated?: ", new Object[]{isUnsaturated});
        return isUnsaturated;
    }

    public boolean saturateByIncreasingBondOrder(IBond bond, IAtomContainer atomContainer) throws CDKException {
        IAtom[] atoms = BondManipulator.getAtomArray((IBond)bond);
        IAtom atom = atoms[0];
        IAtom partner = atoms[1];
        logger.debug((Object)"  saturating bond: ", new Object[]{atom.getSymbol(), "-", partner.getSymbol()});
        IAtomType[] atomTypes1 = this.getAtomTypeFactory(bond.getBuilder()).getAtomTypes(atom.getSymbol());
        IAtomType[] atomTypes2 = this.getAtomTypeFactory(bond.getBuilder()).getAtomTypes(partner.getSymbol());
        for (int atCounter1 = 0; atCounter1 < atomTypes1.length; ++atCounter1) {
            IAtomType aType1 = atomTypes1[atCounter1];
            logger.debug((Object)"  condidering atom type: ", new Object[]{aType1});
            if (!this.couldMatchAtomType(atomContainer, atom, aType1)) continue;
            logger.debug((Object)"  trying atom type: ", new Object[]{aType1});
            for (int atCounter2 = 0; atCounter2 < atomTypes2.length; ++atCounter2) {
                IAtomType aType2 = atomTypes2[atCounter2];
                logger.debug((Object)"  condidering partner type: ", new Object[]{aType1});
                if (!this.couldMatchAtomType(atomContainer, partner, atomTypes2[atCounter2])) continue;
                logger.debug((Object)"    with atom type: ", new Object[]{aType2});
                if (!BondManipulator.isLowerOrder((IBond.Order)bond.getOrder(), (IBond.Order)aType2.getMaxBondOrder()) || !BondManipulator.isLowerOrder((IBond.Order)bond.getOrder(), (IBond.Order)aType1.getMaxBondOrder())) continue;
                bond.setOrder(BondManipulator.increaseBondOrder((IBond.Order)bond.getOrder()));
                logger.debug((Object)"Bond order now ", new Object[]{bond.getOrder()});
                return true;
            }
        }
        return false;
    }

    public boolean isSaturated(IBond bond, IAtomContainer atomContainer) throws CDKException {
        logger.debug((Object)"isBondSaturated?: ", new Object[]{bond});
        IAtom[] atoms = BondManipulator.getAtomArray((IBond)bond);
        boolean isSaturated = true;
        for (int i = 0; i < atoms.length; ++i) {
            logger.debug((Object)"isSaturated(Bond, AC): atom I=", new Object[]{i});
            isSaturated = isSaturated && this.isSaturated(atoms[i], atomContainer);
        }
        logger.debug((Object)"isSaturated(Bond, AC): result=", new Object[]{isSaturated});
        return isSaturated;
    }

    @Override
    public boolean isSaturated(IAtomContainer container) throws CDKException {
        return this.allSaturated(container);
    }

    public boolean allSaturated(IAtomContainer ac) throws CDKException {
        logger.debug((Object)"Are all atoms saturated?");
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (this.isSaturated(ac.getAtom(f), ac)) continue;
            return false;
        }
        return true;
    }

    public boolean couldMatchAtomType(IAtom atom, double bondOrderSum, IBond.Order maxBondOrder, IAtomType type) {
        logger.debug((Object)"couldMatchAtomType:   ... matching atom ", new Object[]{atom, " vs ", type});
        int hcount = atom.getImplicitHydrogenCount();
        int charge = atom.getFormalCharge();
        if (charge == type.getFormalCharge()) {
            logger.debug((Object)"couldMatchAtomType:     formal charge matches...");
            if (bondOrderSum + (double)hcount <= type.getBondOrderSum()) {
                logger.debug((Object)"couldMatchAtomType:     bond order sum is OK...");
                if (!BondManipulator.isHigherOrder((IBond.Order)maxBondOrder, (IBond.Order)type.getMaxBondOrder())) {
                    logger.debug((Object)"couldMatchAtomType:     max bond order is OK... We have a match!");
                    return true;
                }
            } else {
                logger.debug((Object)"couldMatchAtomType:      no match", new Object[]{"" + (bondOrderSum + (double)hcount), " > ", "" + type.getBondOrderSum()});
            }
        } else {
            logger.debug((Object)"couldMatchAtomType:     formal charge does NOT match...");
        }
        logger.debug((Object)"couldMatchAtomType:    No Match");
        return false;
    }

    public int calculateNumberOfImplicitHydrogens(IAtom atom, double bondOrderSum, IBond.Order maxBondOrder, int neighbourCount) throws CDKException {
        int missingHydrogens = 0;
        if (atom instanceof IPseudoAtom) {
            logger.debug((Object)"don't figure it out... it simply does not lack H's");
            return 0;
        }
        logger.debug((Object)"Calculating number of missing hydrogen atoms");
        IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            logger.warn((Object)"Element not found in configuration file: ", new Object[]{atom});
            return 0;
        }
        logger.debug((Object)"Found atomtypes: ", new Object[]{atomTypes.length});
        for (int f = 0; f < atomTypes.length; ++f) {
            IAtomType type = atomTypes[f];
            if (!this.couldMatchAtomType(atom, bondOrderSum, maxBondOrder, type)) continue;
            logger.debug((Object)"This type matches: ", new Object[]{type});
            int formalNeighbourCount = type.getFormalNeighbourCount();
            if (type.getHybridization() == CDKConstants.UNSET) {
                missingHydrogens = (int)(type.getBondOrderSum() - bondOrderSum);
                break;
            }
            if (type.getHybridization() == IAtomType.Hybridization.SP3) {
                missingHydrogens = formalNeighbourCount - neighbourCount;
                break;
            }
            if (type.getHybridization() == IAtomType.Hybridization.SP2) {
                missingHydrogens = formalNeighbourCount - neighbourCount;
                break;
            }
            if (type.getHybridization() == IAtomType.Hybridization.SP1) {
                missingHydrogens = formalNeighbourCount - neighbourCount;
                break;
            }
            missingHydrogens = (int)(type.getBondOrderSum() - bondOrderSum);
            break;
        }
        logger.debug((Object)"missing hydrogens: ", new Object[]{missingHydrogens});
        return missingHydrogens;
    }

    @Override
    public boolean isSaturated(IAtom atom, IAtomContainer container) throws CDKException {
        if (atom instanceof IPseudoAtom) {
            logger.debug((Object)"don't figure it out... it simply does not lack H's");
            return true;
        }
        IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            logger.warn((Object)"Missing entry in atom type list for ", new Object[]{atom.getSymbol()});
            return true;
        }
        double bondOrderSum = container.getBondOrderSum(atom);
        IBond.Order maxBondOrder = container.getMaximumBondOrder(atom);
        int hcount = atom.getImplicitHydrogenCount();
        int charge = atom.getFormalCharge();
        logger.debug((Object)"Checking saturation of atom ", new Object[]{atom.getSymbol()});
        logger.debug((Object)"bondOrderSum: ", new Object[]{bondOrderSum});
        logger.debug((Object)"maxBondOrder: ", new Object[]{maxBondOrder});
        logger.debug((Object)"hcount: ", new Object[]{hcount});
        logger.debug((Object)"charge: ", new Object[]{charge});
        boolean elementPlusChargeMatches = false;
        for (int f = 0; f < atomTypes.length; ++f) {
            IAtomType type = atomTypes[f];
            if (!this.couldMatchAtomType(atom, bondOrderSum, maxBondOrder, type)) continue;
            if (bondOrderSum + (double)hcount == type.getBondOrderSum() && !BondManipulator.isHigherOrder((IBond.Order)maxBondOrder, (IBond.Order)type.getMaxBondOrder())) {
                logger.debug((Object)"We have a match: ", new Object[]{type});
                logger.debug((Object)"Atom is saturated: ", new Object[]{atom.getSymbol()});
                return true;
            }
            elementPlusChargeMatches = true;
        }
        if (elementPlusChargeMatches) {
            logger.debug((Object)"No, atom is not saturated.");
            return false;
        }
        logger.error((Object)"Could not find atom type!");
        throw new CDKException("The atom with element " + atom.getSymbol() + " and charge " + charge + " is not found.");
    }

    public int calculateNumberOfImplicitHydrogens(IAtom atom, IAtomContainer container) throws CDKException {
        return this.calculateNumberOfImplicitHydrogens(atom, container.getBondOrderSum(atom), container.getMaximumBondOrder(atom), container.getConnectedAtomsCount(atom));
    }

    protected AtomTypeFactory getAtomTypeFactory(IChemObjectBuilder builder) throws CDKException {
        if (this.structgenATF == null) {
            try {
                this.structgenATF = AtomTypeFactory.getInstance((String)this.atomTypeList, (IChemObjectBuilder)builder);
            }
            catch (Exception exception) {
                logger.debug((Object)exception);
                throw new CDKException("Could not instantiate AtomTypeFactory!", (Throwable)exception);
            }
        }
        return this.structgenATF;
    }

    public boolean couldMatchAtomType(IAtomContainer container, IAtom atom, IAtomType type) {
        double bondOrderSum = container.getBondOrderSum(atom);
        IBond.Order maxBondOrder = container.getMaximumBondOrder(atom);
        return this.couldMatchAtomType(atom, bondOrderSum, maxBondOrder, type);
    }
}

