/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IFragmentAtom;

public class FragmentAtom
extends PseudoAtom
implements IFragmentAtom {
    private static final long serialVersionUID = -6144605920605752463L;
    private IAtomContainer fragment = (IAtomContainer)this.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
    private boolean isExpanded = false;

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean bool) {
        this.isExpanded = bool;
    }

    public IAtomContainer getFragment() {
        return this.fragment;
    }

    public void setFragment(IAtomContainer fragment) {
        this.fragment = fragment;
    }

    @Override
    public void setExactMass(Double mass) {
        throw new IllegalAccessError("Cannot set the mass of a IFragmentAtom.");
    }

    @Override
    public Double getExactMass() {
        double totalMass = 0.0;
        for (IAtom atom : this.fragment.atoms()) {
            totalMass += atom.getExactMass().doubleValue();
        }
        return totalMass;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("FragmentAtom{").append(this.hashCode());
        buffer.append(", A=").append(super.toString());
        if (this.fragment != null) {
            buffer.append(", F=").append(this.fragment.toString());
        }
        buffer.append('}');
        return buffer.toString();
    }

    public IFragmentAtom clone() throws CloneNotSupportedException {
        IFragmentAtom cpy = (IFragmentAtom)super.clone();
        cpy.setFragment(this.fragment.clone());
        cpy.setExpanded(this.isExpanded);
        return cpy;
    }
}

