/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;

@TestClass(value="org.openscience.cdk.isomorphism.StereoMatchPredicateTest")
final class StereoMatch
implements Predicate<int[]> {
    private final IAtomContainer query;
    private final IAtomContainer target;
    private final Map<IAtom, Integer> queryMap;
    private final Map<IAtom, Integer> targetMap;
    private final IStereoElement[] queryElements;
    private final IStereoElement[] targetElements;
    private final Type[] queryTypes;
    private final Type[] targetTypes;
    private final int[] queryStereoIndices;
    private final int[] targetStereoIndices;

    StereoMatch(IAtomContainer query2, IAtomContainer target) {
        this.query = query2;
        this.target = target;
        this.queryMap = StereoMatch.indexAtoms(query2);
        this.targetMap = StereoMatch.indexAtoms(target);
        this.queryElements = new IStereoElement[query2.getAtomCount()];
        this.targetElements = new IStereoElement[target.getAtomCount()];
        this.queryTypes = new Type[query2.getAtomCount()];
        this.targetTypes = new Type[target.getAtomCount()];
        this.queryStereoIndices = StereoMatch.indexElements(this.queryMap, this.queryElements, this.queryTypes, query2);
        this.targetStereoIndices = StereoMatch.indexElements(this.targetMap, this.targetElements, this.targetTypes, target);
    }

    @Override
    @TestMethod(value="tetrahedral_match,tetraherdal_mismatch")
    public boolean apply(int[] mapping) {
        if (this.queryStereoIndices.length > this.targetStereoIndices.length) {
            return false;
        }
        block4: for (int u : this.queryStereoIndices) {
            switch (this.queryTypes[u]) {
                case Tetrahedral: {
                    if (this.checkTetrahedral(u, mapping)) continue block4;
                    return false;
                }
                case Geometric: {
                    if (this.checkGeometric(u, this.otherIndex(u), mapping)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkTetrahedral(int u, int[] mapping) {
        int q;
        int v = mapping[u];
        if (this.targetTypes[v] != Type.Tetrahedral) {
            return false;
        }
        ITetrahedralChirality queryElement = (ITetrahedralChirality)this.queryElements[u];
        ITetrahedralChirality targetElement = (ITetrahedralChirality)this.targetElements[v];
        int[] us = this.neighbors(queryElement, this.queryMap);
        int[] vs = this.neighbors(targetElement, this.targetMap);
        if ((us = this.map(u, v, us, mapping)) == null) {
            return false;
        }
        int p = this.permutationParity(us) * this.parity(queryElement.getStereo());
        return p == (q = this.permutationParity(vs) * this.parity(targetElement.getStereo()));
    }

    private int[] map(int u, int v, int[] us, int[] mapping) {
        if (this.query.getAtom(u).getImplicitHydrogenCount() == 1 && this.target.getAtom(v).getImplicitHydrogenCount() == 0) {
            IAtom explicitHydrogen = this.findHydrogen(((ITetrahedralChirality)this.targetElements[v]).getLigands());
            if (explicitHydrogen == null) {
                return null;
            }
            mapping[u] = this.targetMap.get(explicitHydrogen);
        }
        for (int i = 0; i < us.length; ++i) {
            us[i] = mapping[us[i]];
        }
        mapping[u] = v;
        return us;
    }

    private boolean checkGeometric(int u1, int u2, int[] mapping) {
        int v1 = mapping[u1];
        int v2 = mapping[u2];
        if (this.targetTypes[v1] != Type.Geometric || this.targetTypes[v2] != Type.Geometric) {
            return false;
        }
        IDoubleBondStereochemistry queryElement = (IDoubleBondStereochemistry)this.queryElements[u1];
        IDoubleBondStereochemistry targetElement = (IDoubleBondStereochemistry)this.targetElements[v1];
        if (!targetElement.getStereoBond().contains(this.target.getAtom(v1)) || !targetElement.getStereoBond().contains(this.target.getAtom(v2))) {
            return false;
        }
        boolean swap = false;
        if (targetElement.getStereoBond().getAtom(0) != this.target.getAtom(v1)) {
            int tmp = v1;
            v1 = v2;
            v2 = tmp;
            swap = true;
        }
        IBond[] queryBonds = queryElement.getBonds();
        IBond[] targetBonds = targetElement.getBonds();
        int p = this.parity(queryElement.getStereo());
        int q = this.parity(targetElement.getStereo());
        int uLeft = this.queryMap.get(queryBonds[0].getConnectedAtom(this.query.getAtom(u1)));
        int uRight = this.queryMap.get(queryBonds[1].getConnectedAtom(this.query.getAtom(u2)));
        int vLeft = this.targetMap.get(targetBonds[0].getConnectedAtom(this.target.getAtom(v1)));
        int vRight = this.targetMap.get(targetBonds[1].getConnectedAtom(this.target.getAtom(v2)));
        if (swap) {
            int tmp = vLeft;
            vLeft = vRight;
            vRight = tmp;
        }
        if (mapping[uLeft] != vLeft) {
            p *= -1;
        }
        if (mapping[uRight] != vRight) {
            p *= -1;
        }
        return p == q;
    }

    private int[] neighbors(ITetrahedralChirality element, Map<IAtom, Integer> map) {
        IAtom[] atoms = element.getLigands();
        int[] vs = new int[atoms.length];
        for (int i = 0; i < atoms.length; ++i) {
            vs[i] = map.get(atoms[i]);
        }
        return vs;
    }

    private IAtom findHydrogen(IAtom[] atoms) {
        for (IAtom a : atoms) {
            if (!Integer.valueOf(1).equals(a.getAtomicNumber())) continue;
            return a;
        }
        return null;
    }

    private int permutationParity(int[] vs) {
        int n = 0;
        for (int i = 0; i < vs.length; ++i) {
            for (int j = i + 1; j < vs.length; ++j) {
                if (vs[i] <= vs[j]) continue;
                ++n;
            }
        }
        return n & true ? -1 : 1;
    }

    private int otherIndex(int i) {
        IDoubleBondStereochemistry element = (IDoubleBondStereochemistry)this.queryElements[i];
        return this.queryMap.get(element.getStereoBond().getConnectedAtom(this.query.getAtom(i)));
    }

    private static Map<IAtom, Integer> indexAtoms(IAtomContainer container) {
        HashMap<IAtom, Integer> map = Maps.newHashMapWithExpectedSize(container.getAtomCount());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            map.put(container.getAtom(i), i);
        }
        return map;
    }

    private static int[] indexElements(Map<IAtom, Integer> map, IStereoElement[] elements, Type[] types, IAtomContainer container) {
        int[] indices = new int[container.getAtomCount()];
        int nElements = 0;
        for (IStereoElement element : container.stereoElements()) {
            if (element instanceof ITetrahedralChirality) {
                ITetrahedralChirality tc = (ITetrahedralChirality)element;
                int idx = map.get(tc.getChiralAtom());
                elements[idx] = element;
                types[idx] = Type.Tetrahedral;
                indices[nElements++] = idx;
                continue;
            }
            if (!(element instanceof IDoubleBondStereochemistry)) continue;
            IDoubleBondStereochemistry dbs = (IDoubleBondStereochemistry)element;
            int idx1 = map.get(dbs.getStereoBond().getAtom(0));
            int idx2 = map.get(dbs.getStereoBond().getAtom(1));
            elements[idx2] = elements[idx1] = element;
            types[idx1] = types[idx2] = Type.Geometric;
            indices[nElements++] = idx1;
        }
        return Arrays.copyOf(indices, nElements);
    }

    private int parity(ITetrahedralChirality.Stereo stereo) {
        return stereo == ITetrahedralChirality.Stereo.CLOCKWISE ? 1 : -1;
    }

    private int parity(IDoubleBondStereochemistry.Conformation conformation) {
        return conformation == IDoubleBondStereochemistry.Conformation.TOGETHER ? 1 : -1;
    }

    private static enum Type {
        Tetrahedral,
        Geometric;

    }
}

