/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.cml.ICMLModule;

@TestClass(value="org.openscience.cdk.io.cml.CMLStackTest")
public class CMLModuleStack {
    ICMLModule[] stack = new ICMLModule[64];
    int sp = 0;

    @TestMethod(value="testPush_String")
    public void push(ICMLModule item) {
        if (this.sp == this.stack.length) {
            ICMLModule[] temp = new ICMLModule[2 * this.sp];
            System.arraycopy(this.stack, 0, temp, 0, this.sp);
            this.stack = temp;
        }
        this.stack[this.sp++] = item;
    }

    public int length() {
        return this.sp;
    }

    @TestMethod(value="testPop")
    public ICMLModule pop() {
        return this.stack[--this.sp];
    }

    @TestMethod(value="testCurrent")
    public ICMLModule current() {
        if (this.sp > 0) {
            return this.stack[this.sp - 1];
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("/");
        for (int i = 0; i < this.sp; ++i) {
            sb.append(this.stack[i].getClass().getSimpleName());
            sb.append("/");
        }
        return sb.toString();
    }

    @TestMethod(value="testEndsWith_String")
    public boolean endsWith(ICMLModule lastElement) {
        return this.stack[this.sp - 1].equals(lastElement);
    }

    @TestMethod(value="testEndsWith_String_String")
    public boolean endsWith(ICMLModule oneButLast, ICMLModule lastElement) {
        return this.endsWith(lastElement) && this.stack[this.sp - 2].equals(oneButLast);
    }

    @TestMethod(value="testEndsWith_String_String_String")
    public boolean endsWith(ICMLModule twoButLast, ICMLModule oneButLast, ICMLModule lastElement) {
        return this.endsWith(oneButLast, lastElement) && this.stack[this.sp - 3].equals(twoButLast);
    }
}

