/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.cip;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.VisitedAtoms;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.geometry.cip.LigandTest")
public class Ligand
implements ILigand {
    private IAtomContainer container;
    private IAtom centralAtom;
    private IAtom ligandAtom;
    private VisitedAtoms visitedAtoms;

    @TestMethod(value="testConstructorAndGetMethods")
    public Ligand(IAtomContainer container, VisitedAtoms visitedAtoms, IAtom centralAtom, IAtom ligandAtom) {
        this.container = container;
        this.centralAtom = centralAtom;
        this.ligandAtom = ligandAtom;
        this.visitedAtoms = new VisitedAtoms();
        this.visitedAtoms.visited(visitedAtoms);
        this.visitedAtoms.visited(centralAtom);
    }

    @Override
    @TestMethod(value="testConstructorAndGetMethods")
    public IAtomContainer getAtomContainer() {
        return this.container;
    }

    @Override
    @TestMethod(value="testConstructorAndGetMethods")
    public IAtom getCentralAtom() {
        return this.centralAtom;
    }

    @Override
    @TestMethod(value="testConstructorAndGetMethods")
    public IAtom getLigandAtom() {
        return this.ligandAtom;
    }

    @Override
    @TestMethod(value="testVisitedTracking")
    public VisitedAtoms getVisitedAtoms() {
        return this.visitedAtoms;
    }

    @Override
    @TestMethod(value="testVisitedTracking")
    public boolean isVisited(IAtom atom) {
        return this.visitedAtoms.isVisited(atom);
    }
}

