/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.InvalidSmilesException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AddDirectionalLabels
extends AbstractFunction<Graph, Graph> {
    AddDirectionalLabels() {
    }

    @Override
    public Graph apply(Graph g) throws InvalidSmilesException {
        Graph h = new Graph(g.order());
        for (int u = 0; u < g.order(); ++u) {
            h.addAtom(g.atom(u));
            h.addTopology(g.topologyOf(u));
        }
        HashMap<Edge, Edge> replacements = new HashMap<Edge, Edge>();
        HashSet<Edge> remaining = new HashSet<Edge>();
        for (int u = 0; u < g.order(); ++u) {
            for (Edge e : g.edges(u)) {
                if (e.other(u) <= u || e.bond() != Bond.DOUBLE) continue;
                remaining.add(e);
            }
        }
        boolean altered = false;
        do {
            for (Edge e : new ArrayList(remaining)) {
                if (this.replaceImplWithExpl(g, e, replacements)) continue;
                remaining.remove(e);
                altered = true;
            }
        } while (altered && !remaining.isEmpty());
        for (int u = 0; u < g.order(); ++u) {
            for (Edge e : g.edges(u)) {
                if (e.other(u) <= u) continue;
                Edge replacement = (Edge)replacements.get(e);
                if (replacement != null) {
                    e = replacement;
                }
                h.addEdge(e);
            }
        }
        return h;
    }

    private boolean replaceImplWithExpl(Graph g, Edge e, Map<Edge, Edge> acc) throws InvalidSmilesException {
        int u = e.either();
        int v = e.other(u);
        boolean uDone = this.replaceImplWithExpl(g, e, u, acc);
        boolean vDone = this.replaceImplWithExpl(g, e, v, acc);
        return uDone || vDone;
    }

    private boolean replaceImplWithExpl(Graph g, Edge e, int u, Map<Edge, Edge> acc) throws InvalidSmilesException {
        int v;
        Edge existing;
        Edge implicit = null;
        Edge explicit = null;
        for (Edge f : g.edges(u)) {
            Edge f2 = acc.containsKey(f) ? acc.get(f) : f;
            switch (f2.bond(u)) {
                case SINGLE: 
                case IMPLICIT: {
                    if (implicit != null) {
                        return true;
                    }
                    implicit = f;
                    break;
                }
                case DOUBLE: {
                    if (f.equals(e)) break;
                    return false;
                }
                case UP: 
                case DOWN: {
                    if (explicit != null) {
                        if (acc.containsKey(explicit)) {
                            explicit = acc.get(explicit);
                        }
                        if ((f.bond() == Bond.UP || f.bond() == Bond.DOWN) && explicit.bond(u).inverse() != f.bond(u)) {
                            throw new InvalidSmilesException("invalid double bond configuration");
                        }
                        if (explicit.bond(u).inverse() != f2.bond(u)) {
                            acc.put(f, f2.inverse());
                            BitSet visited = new BitSet();
                            visited.set(u);
                            this.invertExistingDirectionalLabels(g, visited, acc, f2.other(u));
                        }
                        return false;
                    }
                    explicit = f;
                }
            }
        }
        if (implicit == null || explicit == null) {
            return false;
        }
        if (acc.containsKey(explicit)) {
            explicit = acc.get(explicit);
        }
        if ((existing = acc.put(implicit, new Edge(u, v = implicit.other(u), explicit.bond(u).inverse()))) != null && existing.bond(u) != explicit.bond(u).inverse()) {
            throw new InvalidSmilesException("unable to assign explict type for " + implicit);
        }
        return false;
    }

    private void invertExistingDirectionalLabels(Graph g, BitSet visited, Map<Edge, Edge> replacement, int u) {
        visited.set(u);
        if (g.topologyOf(u) == null) {
            return;
        }
        for (Edge e : g.edges(u)) {
            int v = e.other(u);
            if (visited.get(v)) continue;
            Edge f = replacement.get(e);
            if (f != null) {
                replacement.put(e, f.inverse());
            } else {
                replacement.put(e, e.inverse());
            }
            this.invertExistingDirectionalLabels(g, visited, replacement, v);
        }
    }
}

