/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.io.Serializable;
import java.util.Comparator;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.fingerprint.SimpleAtomComparatorTest")
public class SimpleAtomComparator
implements Comparator<IAtom>,
Serializable {
    private static final long serialVersionUID = 2345252069991872083L;

    @Override
    @TestMethod(value="testCompare_NullHybridization,testCompare_SameHybridization,testCompare_DifferentHybridization,testCompare_DifferentSymbol")
    public int compare(IAtom o1, IAtom o2) {
        if (o1.getSymbol().equalsIgnoreCase(o2.getSymbol())) {
            if (o1.getHybridization() != null && o2.getHybridization() != null) {
                return o1.getHybridization().compareTo(o2.getHybridization());
            }
            return 0;
        }
        return 10 * o1.getSymbol().compareToIgnoreCase(o2.getSymbol());
    }
}

