/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.result;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;

@TestClass(value="org.openscience.cdk.qsar.result.DoubleArrayResultTest")
public class DoubleArrayResult
extends DoubleArrayResultType {
    private List<Double> array;
    private static final long serialVersionUID = 2345607580017306612L;

    public DoubleArrayResult() {
        super(0);
        this.array = new ArrayList<Double>();
    }

    public DoubleArrayResult(int size) {
        super(size);
        this.array = new ArrayList<Double>(size);
    }

    @TestMethod(value="testAdd_double")
    public void add(double value) {
        this.array.add(value);
    }

    @TestMethod(value="testGet_int")
    public double get(int index) {
        if (index >= this.array.size()) {
            return 0.0;
        }
        return this.array.get(index);
    }

    @TestMethod(value="testSize")
    public int length() {
        return Math.max(super.length(), this.array.size());
    }

    @TestMethod(value="testToString")
    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.length(); ++i) {
            buf.append(this.get(i));
            if (i + 1 >= this.length()) continue;
            buf.append(",");
        }
        return buf.toString();
    }
}

