/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes.xsd.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.shared.impl.JenaParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDDouble
extends XSDDatatype {
    public XSDDouble(String typeName) {
        super(typeName);
    }

    public XSDDouble(String typeName, Class<?> javaClass) {
        super(typeName, javaClass);
    }

    @Override
    public boolean isValidValue(Object valueForm) {
        return valueForm instanceof Double;
    }

    @Override
    public Object parse(String lexicalForm) throws DatatypeFormatException {
        this.checkWhitespace(lexicalForm);
        return super.parse(lexicalForm);
    }

    @Override
    public Object parseValidated(String lex) {
        if (lex.equals("INF")) {
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (lex.equals("-INF")) {
            return new Double(Double.POSITIVE_INFINITY);
        }
        if (lex.equals("NaN")) {
            return new Double(Double.NaN);
        }
        return Double.valueOf(lex);
    }

    protected void checkWhitespace(String lexicalForm) {
        if (JenaParameters.enableWhitespaceCheckingOfTypedLiterals && !lexicalForm.trim().equals(lexicalForm)) {
            throw new DatatypeFormatException(lexicalForm, this, "whitespace violation");
        }
    }

    @Override
    public boolean isEqual(LiteralLabel value1, LiteralLabel value2) {
        return value1.getDatatype() == value2.getDatatype() && value1.getValue().equals(value2.getValue());
    }
}

