/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.BondTools;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.invariant.CanonicalLabeler;
import org.openscience.cdk.graph.invariant.MorganNumbersTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

@TestClass(value="org.openscience.cdk.smiles.SmilesGeneratorTest")
public class SmilesGenerator {
    private int ringMarker = 0;
    private List<BrokenBond> brokenBonds = new ArrayList<BrokenBond>();
    private IsotopeFactory isotopeFactory;
    AllRingsFinder ringFinder;
    private IRingSet rings = null;
    private CanonicalLabeler canLabler = new CanonicalLabeler();
    private final String RING_CONFIG = "stereoconfig";
    private final String UP = "up";
    private final String DOWN = "down";
    private boolean useAromaticityFlag = false;

    public SmilesGenerator() {
    }

    public SmilesGenerator(boolean useAromaticityFlag) {
        this.useAromaticityFlag = useAromaticityFlag;
    }

    public boolean isValidDoubleBondConfiguration(IAtomContainer container, IBond bond) {
        IAtom atom0 = bond.getAtom(0);
        IAtom atom1 = bond.getAtom(1);
        List<IAtom> connectedAtoms = container.getConnectedAtomsList(atom0);
        IAtom from = null;
        for (IAtom connectedAtom : connectedAtoms) {
            if (connectedAtom == atom1) continue;
            from = connectedAtom;
        }
        boolean[] array = new boolean[container.getBondCount()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = true;
        }
        return this.isStartOfDoubleBond(container, atom0, from, array) && this.isEndOfDoubleBond(container, atom1, atom0, array) && !bond.getFlag(32);
    }

    public SmilesGenerator setRings(IRingSet rings) {
        this.rings = rings;
        return this;
    }

    @TestMethod(value="testCisResorcinol,testEthylPropylPhenantren,testAlanin")
    public synchronized String createSMILES(IAtomContainer molecule) {
        try {
            return this.createSMILES(molecule, false, new boolean[molecule.getBondCount()]);
        }
        catch (CDKException exception) {
            return "";
        }
    }

    public synchronized String createSMILES(IReaction reaction) throws CDKException {
        StringBuffer reactionSMILES = new StringBuffer();
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            reactionSMILES.append(this.createSMILES(reactants.getAtomContainer(i)));
            if (i + 1 >= reactants.getAtomContainerCount()) continue;
            reactionSMILES.append('.');
        }
        reactionSMILES.append('>');
        IAtomContainerSet agents = reaction.getAgents();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            reactionSMILES.append(this.createSMILES(agents.getAtomContainer(i)));
            if (i + 1 >= agents.getAtomContainerCount()) continue;
            reactionSMILES.append('.');
        }
        reactionSMILES.append('>');
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            reactionSMILES.append(this.createSMILES(products.getAtomContainer(i)));
            if (i + 1 >= products.getAtomContainerCount()) continue;
            reactionSMILES.append('.');
        }
        return reactionSMILES.toString();
    }

    @TestMethod(value="testAlaSMILES,testSugarSMILES")
    public synchronized String createChiralSMILES(IAtomContainer molecule, boolean[] doubleBondConfiguration) throws CDKException {
        return this.createSMILES(molecule, true, doubleBondConfiguration);
    }

    public synchronized String createSMILES(IAtomContainer molecule, boolean chiral, boolean[] doubleBondConfiguration) throws CDKException {
        IAtomContainerSet moleculeSet = ConnectivityChecker.partitionIntoMolecules(molecule);
        if (moleculeSet.getAtomContainerCount() > 1) {
            StringBuffer fullSMILES = new StringBuffer();
            for (int i = 0; i < moleculeSet.getAtomContainerCount(); ++i) {
                IAtomContainer molPart = moleculeSet.getAtomContainer(i);
                fullSMILES.append(this.createSMILESWithoutCheckForMultipleMolecules(molPart, chiral, doubleBondConfiguration));
                if (i >= moleculeSet.getAtomContainerCount() - 1) continue;
                fullSMILES.append('.');
            }
            return fullSMILES.toString();
        }
        return this.createSMILESWithoutCheckForMultipleMolecules(molecule, chiral, doubleBondConfiguration);
    }

    @TestMethod(value="testCreateSMILESWithoutCheckForMultipleMolecules_withDetectAromaticity,testCreateSMILESWithoutCheckForMultipleMolecules_withoutDetectAromaticity")
    public synchronized String createSMILESWithoutCheckForMultipleMolecules(IAtomContainer molecule, boolean chiral, boolean[] doubleBondConfiguration) throws CDKException {
        if (molecule.getAtomCount() == 0) {
            return "";
        }
        this.canLabler.canonLabel(molecule);
        this.brokenBonds.clear();
        this.ringMarker = 0;
        IAtom start = null;
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            IAtom atom = molecule.getAtom(i);
            if (chiral && atom.getPoint2d() == null) {
                throw new CDKException("Atom number " + i + " has no 2D coordinates, but 2D coordinates are needed for creating chiral smiles");
            }
            atom.setFlag(16, false);
            if ((Long)atom.getProperty("CanonicalLabel") != 1L) continue;
            start = atom;
        }
        if (this.useAromaticityFlag || chiral) {
            if (this.rings == null) {
                if (this.ringFinder == null) {
                    this.ringFinder = new AllRingsFinder();
                }
                this.rings = this.ringFinder.findAllRings(molecule);
            }
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(molecule);
            CDKHueckelAromaticityDetector.detectAromaticity(molecule);
        }
        if (chiral && this.rings.getAtomContainerCount() > 0) {
            List<IRingSet> v = RingPartitioner.partitionRings(this.rings);
            for (int i = 0; i < v.size(); ++i) {
                int counter = 0;
                for (IAtomContainer allrings : RingSetManipulator.getAllAtomContainers(v.get(i))) {
                    IBond bond;
                    int k;
                    for (k = 0; k < allrings.getAtomCount(); ++k) {
                        if (BondTools.isStereo(molecule, allrings.getAtom(k)) || this.hasWedges(molecule, allrings.getAtom(k)) == null) continue;
                        bond = molecule.getBond(allrings.getAtom(k), this.hasWedges(molecule, allrings.getAtom(k)));
                        if (bond.getStereo() == IBond.Stereo.UP) {
                            allrings.getAtom(k).setProperty("stereoconfig", "up");
                        } else {
                            allrings.getAtom(k).setProperty("stereoconfig", "down");
                        }
                        ++counter;
                    }
                    if (counter != true) continue;
                    for (k = 0; k < allrings.getAtomCount(); ++k) {
                        bond = molecule.getBond(allrings.getAtom(k), this.hasWedges(molecule, allrings.getAtom(k)));
                        if (bond == null) continue;
                        if (bond.getStereo() == IBond.Stereo.UP) {
                            allrings.getAtom(k).setProperty("stereoconfig", "up");
                            continue;
                        }
                        allrings.getAtom(k).setProperty("stereoconfig", "down");
                    }
                }
            }
        }
        StringBuffer l = new StringBuffer();
        this.createSMILES(start, l, molecule, chiral, doubleBondConfiguration, this.useAromaticityFlag);
        this.rings = null;
        for (int k = 0; k < molecule.getAtomCount(); ++k) {
            molecule.getAtom(k).removeProperty("CanonicalLabel");
            molecule.getAtom(k).removeProperty("InvariancePair");
        }
        return l.toString();
    }

    private IAtom hasWedges(IAtomContainer ac, IAtom a) {
        List<IAtom> atoms = ac.getConnectedAtomsList(a);
        for (IAtom atom : atoms) {
            if (ac.getBond(a, atom).getStereo() == IBond.Stereo.NONE) continue;
            return atom;
        }
        return null;
    }

    private boolean isEndOfDoubleBond(IAtomContainer container, IAtom atom, IAtom parent, boolean[] doubleBondConfiguration) {
        if (container.getBondNumber(atom, parent) == -1 || doubleBondConfiguration.length <= container.getBondNumber(atom, parent) || !doubleBondConfiguration[container.getBondNumber(atom, parent)]) {
            return false;
        }
        int lengthAtom = container.getConnectedAtomsCount(atom) + (atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount());
        int lengthParent = container.getConnectedAtomsCount(parent) + (parent.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : parent.getImplicitHydrogenCount());
        if (container.getBond(atom, parent) != null && container.getBond(atom, parent).getOrder() == CDKConstants.BONDORDER_DOUBLE && (lengthAtom == 3 || lengthAtom == 2 && atom.getSymbol().equals("N")) && (lengthParent == 3 || lengthParent == 2 && parent.getSymbol().equals("N"))) {
            List<IAtom> atoms = container.getConnectedAtomsList(atom);
            IAtom one = null;
            IAtom two = null;
            IAtom atomi = null;
            for (int i = 0; i < atoms.size(); ++i) {
                atomi = container.getAtom(i);
                if (atomi != parent && one == null) {
                    one = atomi;
                    continue;
                }
                if (atomi == parent || one == null) continue;
                two = atomi;
            }
            String[] morgannumbers = MorganNumbersTools.getMorganNumbersWithElementSymbol(container);
            return one != null && two == null && atom.getSymbol().equals("N") && Math.abs(BondTools.giveAngleBothMethods(parent, atom, one, true)) > 0.3141592653589793 || !atom.getSymbol().equals("N") && one != null && two != null && !morgannumbers[container.getAtomNumber(one)].equals(morgannumbers[container.getAtomNumber(two)]);
        }
        return false;
    }

    private boolean isStartOfDoubleBond(IAtomContainer container, IAtom a, IAtom parent, boolean[] doubleBondConfiguration) {
        int lengthAtom = container.getConnectedAtomsCount(a) + (a.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : a.getImplicitHydrogenCount());
        if (lengthAtom != 3 && lengthAtom != 2 && !a.getSymbol().equals("N")) {
            return false;
        }
        List<IAtom> atoms = container.getConnectedAtomsList(a);
        IAtom one = null;
        IAtom two = null;
        boolean doubleBond = false;
        IAtom nextAtom = null;
        for (IAtom atomi : atoms) {
            if (atomi != parent && container.getBond(atomi, a).getOrder() == CDKConstants.BONDORDER_DOUBLE && this.isEndOfDoubleBond(container, atomi, a, doubleBondConfiguration)) {
                doubleBond = true;
                nextAtom = atomi;
            }
            if (atomi != nextAtom && one == null) {
                one = atomi;
                continue;
            }
            if (atomi == nextAtom || one == null) continue;
            two = atomi;
        }
        String[] morgannumbers = MorganNumbersTools.getMorganNumbersWithElementSymbol(container);
        return one != null && (!a.getSymbol().equals("N") && two != null && !morgannumbers[container.getAtomNumber(one)].equals(morgannumbers[container.getAtomNumber(two)]) && doubleBond && doubleBondConfiguration[container.getBondNumber(a, nextAtom)] || doubleBond && a.getSymbol().equals("N") && Math.abs(BondTools.giveAngleBothMethods(nextAtom, a, parent, true)) > 0.3141592653589793);
    }

    private boolean isBondBroken(IAtom a1, IAtom a2) {
        for (BrokenBond bond : this.brokenBonds) {
            if (!bond.getA1().equals(a1) && !bond.getA1().equals(a2) || !bond.getA2().equals(a1) && !bond.getA2().equals(a2)) continue;
            return true;
        }
        return false;
    }

    private boolean isRingOpening(IAtom a1, List v) {
        for (BrokenBond bond : this.brokenBonds) {
            for (Object aV : v) {
                if ((!bond.getA1().equals(a1) || !bond.getA2().equals((IAtom)aV)) && (!bond.getA1().equals((IAtom)aV) || !bond.getA2().equals(a1))) continue;
                return true;
            }
        }
        return false;
    }

    private List getCanNeigh(IAtom a, IAtomContainer container) {
        List<IAtom> v = container.getConnectedAtomsList(a);
        if (v.size() > 1) {
            Collections.sort(v, new Comparator<IAtom>(){

                @Override
                public int compare(IAtom o1, IAtom o2) {
                    return this.label(o1).compareTo(this.label(o2));
                }

                private Long label(IAtom atom) {
                    Long label = (Long)atom.getProperty("CanonicalLabel");
                    return label != null ? label : Long.MIN_VALUE;
                }
            });
        }
        return v;
    }

    private List getRingOpenings(IAtom a, List vbonds) {
        Iterator<BrokenBond> it = this.brokenBonds.iterator();
        Vector<Integer> v = new Vector<Integer>(10);
        while (it.hasNext()) {
            BrokenBond bond = it.next();
            if (!bond.getA1().equals(a) && !bond.getA2().equals(a)) continue;
            v.add(bond.getMarker());
            if (vbonds == null) continue;
            vbonds.add(bond.getA1().equals(a) ? bond.getA2() : bond.getA1());
        }
        Collections.sort(v);
        return v;
    }

    private void addAtoms(List v, List result) {
        for (Object aV : v) {
            if (aV instanceof IAtom) {
                result.add((IAtom)aV);
                continue;
            }
            this.addAtoms((List)aV, result);
        }
    }

    private void createSMILES(IAtom a, StringBuffer line, IAtomContainer atomContainer, boolean chiral, boolean[] doubleBondConfiguration, boolean useAromaticity) {
        Vector tree = new Vector();
        Iterator<IAtom> atoms = atomContainer.atoms().iterator();
        while (atoms.hasNext()) {
            atoms.next().setFlag(16, false);
        }
        this.createDFSTree(a, tree, null, atomContainer);
        this.parseChain(tree, line, atomContainer, null, chiral, doubleBondConfiguration, new Vector(), useAromaticity);
    }

    private void createDFSTree(IAtom a, List tree, IAtom parent, IAtomContainer container) {
        tree.add(a);
        ArrayList neighbours = new ArrayList(this.getCanNeigh(a, container));
        neighbours.remove(parent);
        a.setFlag(16, true);
        Iterator iter = neighbours.iterator();
        while (iter.hasNext()) {
            IAtom next = (IAtom)iter.next();
            if (!next.getFlag(16)) {
                if (!iter.hasNext()) {
                    this.createDFSTree(next, tree, a, container);
                    continue;
                }
                Vector branch = new Vector();
                tree.add(branch);
                this.createDFSTree(next, branch, a, container);
                continue;
            }
            ++this.ringMarker;
            BrokenBond bond = new BrokenBond(a, next, this.ringMarker);
            if (!this.brokenBonds.contains(bond)) {
                this.brokenBonds.add(bond);
                continue;
            }
            --this.ringMarker;
        }
    }

    private void parseChain(List v, StringBuffer buffer, IAtomContainer container, IAtom parent, boolean chiral, boolean[] doubleBondConfiguration, List atomsInOrderOfSmiles, boolean useAromaticity) {
        int positionInVector = 0;
        for (int h = 0; h < v.size(); ++h) {
            Object o = v.get(h);
            if (o instanceof IAtom) {
                IAtom atom = (IAtom)o;
                if (parent != null) {
                    this.parseBond(buffer, atom, parent, container, useAromaticity);
                } else if (chiral && BondTools.isStereo(container, atom)) {
                    parent = (IAtom)((List)v.get(1)).get(0);
                }
                this.parseAtom(atom, buffer, container, chiral, doubleBondConfiguration, parent, atomsInOrderOfSmiles, v, useAromaticity);
                if (chiral && BondTools.isStereo(container, atom) && container.getBond(parent, atom) != null) {
                    int i;
                    IAtom atom2;
                    IAtom atom1;
                    double angle2;
                    int i2;
                    int i3;
                    IAtom[] sorted = null;
                    List<IAtom> chiralNeighbours = container.getConnectedAtomsList(atom);
                    if (BondTools.isTetrahedral(container, atom, false) > 0) {
                        sorted = new IAtom[3];
                    }
                    if (BondTools.isTetrahedral(container, atom, false) == 1) {
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.DOWN) {
                            for (i3 = 0; i3 < chiralNeighbours.size(); ++i3) {
                                if (chiralNeighbours.get(i3) == parent) continue;
                                if ((container.getBond(chiralNeighbours.get(i3), atom).getStereo() == null || container.getBond(chiralNeighbours.get(i3), atom).getStereo() == IBond.Stereo.NONE) && BondTools.isLeft(chiralNeighbours.get(i3), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i3), atom)) {
                                    sorted[2] = chiralNeighbours.get(i3);
                                }
                                if (!(container.getBond(chiralNeighbours.get(i3), atom).getStereo() != null && container.getBond(chiralNeighbours.get(i3), atom).getStereo() != IBond.Stereo.NONE || BondTools.isLeft(chiralNeighbours.get(i3), parent, atom) || this.isBondBroken(chiralNeighbours.get(i3), atom))) {
                                    sorted[1] = chiralNeighbours.get(i3);
                                }
                                if (container.getBond(chiralNeighbours.get(i3), atom).getStereo() != IBond.Stereo.UP || this.isBondBroken(chiralNeighbours.get(i3), atom)) continue;
                                sorted[0] = chiralNeighbours.get(i3);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.UP) {
                            for (i3 = 0; i3 < chiralNeighbours.size(); ++i3) {
                                if (chiralNeighbours.get(i3) == parent) continue;
                                if ((container.getBond(chiralNeighbours.get(i3), atom).getStereo() == null || container.getBond(chiralNeighbours.get(i3), atom).getStereo() == IBond.Stereo.NONE) && BondTools.isLeft(chiralNeighbours.get(i3), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i3), atom)) {
                                    sorted[1] = chiralNeighbours.get(i3);
                                }
                                if (!(container.getBond(chiralNeighbours.get(i3), atom).getStereo() != null && container.getBond(chiralNeighbours.get(i3), atom).getStereo() != IBond.Stereo.NONE || BondTools.isLeft(chiralNeighbours.get(i3), parent, atom) || this.isBondBroken(chiralNeighbours.get(i3), atom))) {
                                    sorted[2] = chiralNeighbours.get(i3);
                                }
                                if (container.getBond(chiralNeighbours.get(i3), atom).getStereo() != IBond.Stereo.DOWN || this.isBondBroken(chiralNeighbours.get(i3), atom)) continue;
                                sorted[0] = chiralNeighbours.get(i3);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == CDKConstants.UNSET || container.getBond(parent, atom).getStereo() == IBond.Stereo.NONE) {
                            boolean normalBindingIsLeft = false;
                            for (i2 = 0; i2 < chiralNeighbours.size(); ++i2) {
                                if (chiralNeighbours.get(i2) == parent || container.getBond(chiralNeighbours.get(i2), atom).getStereo() != null && container.getBond(chiralNeighbours.get(i2), atom).getStereo() != IBond.Stereo.NONE || !BondTools.isLeft(chiralNeighbours.get(i2), parent, atom)) continue;
                                normalBindingIsLeft = true;
                                break;
                            }
                            for (i2 = 0; i2 < chiralNeighbours.size(); ++i2) {
                                if (chiralNeighbours.get(i2) == parent) continue;
                                if (normalBindingIsLeft) {
                                    if (container.getBond(chiralNeighbours.get(i2), atom).getStereo() == null || container.getBond(chiralNeighbours.get(i2), atom).getStereo() == IBond.Stereo.NONE) {
                                        sorted[0] = chiralNeighbours.get(i2);
                                    }
                                    if (container.getBond(chiralNeighbours.get(i2), atom).getStereo() == IBond.Stereo.UP) {
                                        sorted[2] = chiralNeighbours.get(i2);
                                    }
                                    if (container.getBond(chiralNeighbours.get(i2), atom).getStereo() != IBond.Stereo.DOWN) continue;
                                    sorted[1] = chiralNeighbours.get(i2);
                                    continue;
                                }
                                if (container.getBond(chiralNeighbours.get(i2), atom).getStereo() == IBond.Stereo.UP) {
                                    sorted[1] = chiralNeighbours.get(i2);
                                }
                                if (container.getBond(chiralNeighbours.get(i2), atom).getStereo() == null || container.getBond(chiralNeighbours.get(i2), atom).getStereo() == IBond.Stereo.NONE) {
                                    sorted[0] = chiralNeighbours.get(i2);
                                }
                                if (container.getBond(chiralNeighbours.get(i2), atom).getStereo() != IBond.Stereo.DOWN) continue;
                                sorted[2] = chiralNeighbours.get(i2);
                            }
                        }
                    }
                    if (BondTools.isTetrahedral(container, atom, false) == 2) {
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.UP) {
                            for (i3 = 0; i3 < chiralNeighbours.size(); ++i3) {
                                if (chiralNeighbours.get(i3) == parent) continue;
                                if (container.getBond(chiralNeighbours.get(i3), atom).getStereo() == IBond.Stereo.DOWN && BondTools.isLeft(chiralNeighbours.get(i3), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i3), atom)) {
                                    sorted[1] = chiralNeighbours.get(i3);
                                }
                                if (container.getBond(chiralNeighbours.get(i3), atom).getStereo() == IBond.Stereo.DOWN && !BondTools.isLeft(chiralNeighbours.get(i3), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i3), atom)) {
                                    sorted[2] = chiralNeighbours.get(i3);
                                }
                                if (container.getBond(chiralNeighbours.get(i3), atom).getStereo() != IBond.Stereo.UP || this.isBondBroken(chiralNeighbours.get(i3), atom)) continue;
                                sorted[0] = chiralNeighbours.get(i3);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.DOWN) {
                            double angle1 = 0.0;
                            angle2 = 0.0;
                            atom1 = null;
                            atom2 = null;
                            for (i = 0; i < chiralNeighbours.size(); ++i) {
                                if (chiralNeighbours.get(i) == parent) continue;
                                if (container.getBond(chiralNeighbours.get(i), atom).getStereo() == IBond.Stereo.UP && !this.isBondBroken(chiralNeighbours.get(i), atom)) {
                                    if (angle1 == 0.0) {
                                        angle1 = BondTools.giveAngle(atom, parent, chiralNeighbours.get(i));
                                        atom1 = chiralNeighbours.get(i);
                                    } else {
                                        angle2 = BondTools.giveAngle(atom, parent, chiralNeighbours.get(i));
                                        atom2 = chiralNeighbours.get(i);
                                    }
                                }
                                if (container.getBond(chiralNeighbours.get(i), atom).getStereo() != IBond.Stereo.DOWN || this.isBondBroken(chiralNeighbours.get(i), atom)) continue;
                                sorted[1] = chiralNeighbours.get(i);
                            }
                            if (angle1 < angle2) {
                                sorted[0] = atom2;
                                sorted[2] = atom1;
                            } else {
                                sorted[0] = atom1;
                                sorted[2] = atom2;
                            }
                        }
                    }
                    if (BondTools.isTetrahedral(container, atom, false) == 3) {
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.UP) {
                            TreeMap<Double, Integer> hm = new TreeMap<Double, Integer>();
                            for (i2 = 0; i2 < chiralNeighbours.size(); ++i2) {
                                if (chiralNeighbours.get(i2) == parent || this.isBondBroken(chiralNeighbours.get(i2), atom)) continue;
                                hm.put(new Double(BondTools.giveAngle(atom, parent, chiralNeighbours.get(i2))), i2);
                            }
                            Object[] ohere = hm.values().toArray();
                            for (int i4 = ohere.length - 1; i4 > -1; --i4) {
                                sorted[i4] = chiralNeighbours.get((Integer)ohere[i4]);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == null || container.getBond(parent, atom).getStereo() == IBond.Stereo.NONE) {
                            double angle1 = 0.0;
                            angle2 = 0.0;
                            atom1 = null;
                            atom2 = null;
                            for (i = 0; i < chiralNeighbours.size(); ++i) {
                                if (chiralNeighbours.get(i) == parent) continue;
                                if (!(container.getBond(chiralNeighbours.get(i), atom).getStereo() != null && container.getBond(chiralNeighbours.get(i), atom).getStereo() != IBond.Stereo.NONE || this.isBondBroken(chiralNeighbours.get(i), atom))) {
                                    if (angle1 == 0.0) {
                                        angle1 = BondTools.giveAngle(atom, parent, chiralNeighbours.get(i));
                                        atom1 = chiralNeighbours.get(i);
                                    } else {
                                        angle2 = BondTools.giveAngle(atom, parent, chiralNeighbours.get(i));
                                        atom2 = chiralNeighbours.get(i);
                                    }
                                }
                                if (container.getBond(chiralNeighbours.get(i), atom).getStereo() != IBond.Stereo.UP || this.isBondBroken(chiralNeighbours.get(i), atom)) continue;
                                sorted[0] = chiralNeighbours.get(i);
                            }
                            if (angle1 < angle2) {
                                sorted[1] = atom2;
                                sorted[2] = atom1;
                            } else {
                                sorted[1] = atom1;
                                sorted[2] = atom2;
                            }
                        }
                    }
                    if (BondTools.isTetrahedral(container, atom, false) == 4) {
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.DOWN) {
                            TreeMap<Double, Integer> hm = new TreeMap<Double, Integer>();
                            for (int i5 = 0; i5 < chiralNeighbours.size(); ++i5) {
                                if (chiralNeighbours.get(i5) == parent || this.isBondBroken(chiralNeighbours.get(i5), atom)) continue;
                                hm.put(new Double(BondTools.giveAngle(atom, parent, chiralNeighbours.get(i5))), i5);
                            }
                            Object[] ohere = hm.values().toArray();
                            for (int i6 = ohere.length - 1; i6 > -1; --i6) {
                                sorted[i6] = chiralNeighbours.get((Integer)ohere[i6]);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == null || container.getBond(parent, atom).getStereo() == IBond.Stereo.NONE) {
                            double angle1 = 0.0;
                            double angle22 = 0.0;
                            atom1 = null;
                            atom2 = null;
                            for (i = 0; i < chiralNeighbours.size(); ++i) {
                                if (chiralNeighbours.get(i) == parent) continue;
                                if (!(container.getBond(chiralNeighbours.get(i), atom).getStereo() != null && container.getBond(chiralNeighbours.get(i), atom).getStereo() != IBond.Stereo.NONE || this.isBondBroken(chiralNeighbours.get(i), atom))) {
                                    if (angle1 == 0.0) {
                                        angle1 = BondTools.giveAngle(atom, parent, chiralNeighbours.get(i));
                                        atom1 = chiralNeighbours.get(i);
                                    } else {
                                        angle22 = BondTools.giveAngle(atom, parent, chiralNeighbours.get(i));
                                        atom2 = chiralNeighbours.get(i);
                                    }
                                }
                                if (container.getBond(chiralNeighbours.get(i), atom).getStereo() != IBond.Stereo.DOWN || this.isBondBroken(chiralNeighbours.get(i), atom)) continue;
                                sorted[2] = chiralNeighbours.get(i);
                            }
                            if (angle1 < angle22) {
                                sorted[1] = atom2;
                                sorted[0] = atom1;
                            } else {
                                sorted[1] = atom1;
                                sorted[0] = atom2;
                            }
                        }
                    }
                    if (BondTools.isTetrahedral(container, atom, false) == 5) {
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.DOWN) {
                            for (int i7 = 0; i7 < chiralNeighbours.size(); ++i7) {
                                if (chiralNeighbours.get(i7) == parent) continue;
                                if (container.getBond(chiralNeighbours.get(i7), atom).getStereo() == IBond.Stereo.UP) {
                                    sorted[0] = chiralNeighbours.get(i7);
                                }
                                if (container.getBond(chiralNeighbours.get(i7), atom).getStereo() == null || container.getBond(chiralNeighbours.get(i7), atom).getStereo() == IBond.Stereo.NONE) {
                                    sorted[2] = chiralNeighbours.get(i7);
                                }
                                if (container.getBond(chiralNeighbours.get(i7), atom).getStereo() != IBond.Stereo.DOWN) continue;
                                sorted[1] = chiralNeighbours.get(i7);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.UP) {
                            for (int i8 = 0; i8 < chiralNeighbours.size(); ++i8) {
                                if (chiralNeighbours.get(i8) == parent) continue;
                                if (container.getBond(chiralNeighbours.get(i8), atom).getStereo() == IBond.Stereo.DOWN && BondTools.isLeft(chiralNeighbours.get(i8), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i8), atom)) {
                                    sorted[0] = chiralNeighbours.get(i8);
                                }
                                if (container.getBond(chiralNeighbours.get(i8), atom).getStereo() == IBond.Stereo.DOWN && !BondTools.isLeft(chiralNeighbours.get(i8), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i8), atom)) {
                                    sorted[2] = chiralNeighbours.get(i8);
                                }
                                if (container.getBond(chiralNeighbours.get(i8), atom).getStereo() != null && container.getBond(chiralNeighbours.get(i8), atom).getStereo() != IBond.Stereo.NONE) continue;
                                sorted[1] = chiralNeighbours.get(i8);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == CDKConstants.UNSET || container.getBond(parent, atom).getStereo() == IBond.Stereo.NONE) {
                            for (int i9 = 0; i9 < chiralNeighbours.size(); ++i9) {
                                if (chiralNeighbours.get(i9) == parent) continue;
                                if (container.getBond(chiralNeighbours.get(i9), atom).getStereo() == IBond.Stereo.DOWN && BondTools.isLeft(chiralNeighbours.get(i9), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i9), atom)) {
                                    sorted[0] = chiralNeighbours.get(i9);
                                }
                                if (container.getBond(chiralNeighbours.get(i9), atom).getStereo() == IBond.Stereo.DOWN && !BondTools.isLeft(chiralNeighbours.get(i9), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i9), atom)) {
                                    sorted[2] = chiralNeighbours.get(i9);
                                }
                                if (container.getBond(chiralNeighbours.get(i9), atom).getStereo() != IBond.Stereo.UP) continue;
                                sorted[1] = chiralNeighbours.get(i9);
                            }
                        }
                    }
                    if (BondTools.isTetrahedral(container, atom, false) == 6) {
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.UP) {
                            for (int i10 = 0; i10 < chiralNeighbours.size(); ++i10) {
                                if (chiralNeighbours.get(i10) == parent) continue;
                                if (container.getBond(chiralNeighbours.get(i10), atom).getStereo() == IBond.Stereo.UP) {
                                    sorted[0] = chiralNeighbours.get(i10);
                                }
                                if (container.getBond(chiralNeighbours.get(i10), atom).getStereo() == null || container.getBond(chiralNeighbours.get(i10), atom).getStereo() == IBond.Stereo.NONE) {
                                    sorted[2] = chiralNeighbours.get(i10);
                                }
                                if (container.getBond(chiralNeighbours.get(i10), atom).getStereo() != IBond.Stereo.DOWN) continue;
                                sorted[1] = chiralNeighbours.get(i10);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.DOWN) {
                            for (int i11 = 0; i11 < chiralNeighbours.size(); ++i11) {
                                if (chiralNeighbours.get(i11) == parent) continue;
                                if (container.getBond(chiralNeighbours.get(i11), atom).getStereo() == IBond.Stereo.UP && BondTools.isLeft(chiralNeighbours.get(i11), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i11), atom)) {
                                    sorted[2] = chiralNeighbours.get(i11);
                                }
                                if (container.getBond(chiralNeighbours.get(i11), atom).getStereo() == IBond.Stereo.UP && !BondTools.isLeft(chiralNeighbours.get(i11), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i11), atom)) {
                                    sorted[0] = chiralNeighbours.get(i11);
                                }
                                if (container.getBond(chiralNeighbours.get(i11), atom).getStereo() != null && container.getBond(chiralNeighbours.get(i11), atom).getStereo() != IBond.Stereo.NONE) continue;
                                sorted[1] = chiralNeighbours.get(i11);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == CDKConstants.UNSET || container.getBond(parent, atom).getStereo() == IBond.Stereo.NONE) {
                            for (int i12 = 0; i12 < chiralNeighbours.size(); ++i12) {
                                if (chiralNeighbours.get(i12) == parent) continue;
                                if (container.getBond(chiralNeighbours.get(i12), atom).getStereo() == IBond.Stereo.UP && BondTools.isLeft(chiralNeighbours.get(i12), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i12), atom)) {
                                    sorted[2] = chiralNeighbours.get(i12);
                                }
                                if (container.getBond(chiralNeighbours.get(i12), atom).getStereo() == IBond.Stereo.UP && !BondTools.isLeft(chiralNeighbours.get(i12), parent, atom) && !this.isBondBroken(chiralNeighbours.get(i12), atom)) {
                                    sorted[0] = chiralNeighbours.get(i12);
                                }
                                if (container.getBond(chiralNeighbours.get(i12), atom).getStereo() != IBond.Stereo.DOWN) continue;
                                sorted[1] = chiralNeighbours.get(i12);
                            }
                        }
                    }
                    if (BondTools.isSquarePlanar(container, atom)) {
                        sorted = new IAtom[3];
                        TreeMap<Double, Integer> hm = new TreeMap<Double, Integer>();
                        for (int i13 = 0; i13 < chiralNeighbours.size(); ++i13) {
                            if (chiralNeighbours.get(i13) == parent || this.isBondBroken(chiralNeighbours.get(i13), atom)) continue;
                            hm.put(new Double(BondTools.giveAngle(atom, parent, chiralNeighbours.get(i13))), i13);
                        }
                        Object[] ohere = hm.values().toArray();
                        for (int i14 = 0; i14 < ohere.length; ++i14) {
                            sorted[i14] = chiralNeighbours.get((Integer)ohere[i14]);
                        }
                    }
                    if (BondTools.isTrigonalBipyramidalOrOctahedral(container, atom) != 0) {
                        sorted = new IAtom[container.getConnectedAtomsCount(atom) - 1];
                        TreeMap<Double, Integer> hm = new TreeMap<Double, Integer>();
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.UP) {
                            for (int i15 = 0; i15 < chiralNeighbours.size(); ++i15) {
                                if (container.getBond(atom, chiralNeighbours.get(i15)).getStereo() == null || container.getBond(atom, chiralNeighbours.get(i15)).getStereo() == IBond.Stereo.NONE) {
                                    hm.put(new Double(BondTools.giveAngle(atom, parent, chiralNeighbours.get(i15))), i15);
                                }
                                if (container.getBond(atom, chiralNeighbours.get(i15)).getStereo() != IBond.Stereo.DOWN) continue;
                                sorted[sorted.length - 1] = chiralNeighbours.get(i15);
                            }
                            Object[] ohere = hm.values().toArray();
                            for (int i16 = 0; i16 < ohere.length; ++i16) {
                                sorted[i16] = chiralNeighbours.get((Integer)ohere[i16]);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == IBond.Stereo.DOWN) {
                            for (int i17 = 0; i17 < chiralNeighbours.size(); ++i17) {
                                if (container.getBond(atom, chiralNeighbours.get(i17)).getStereo() == null || container.getBond(atom, chiralNeighbours.get(i17)).getStereo() == IBond.Stereo.NONE) {
                                    hm.put(new Double(BondTools.giveAngle(atom, parent, chiralNeighbours.get(i17))), i17);
                                }
                                if (container.getBond(atom, chiralNeighbours.get(i17)).getStereo() != IBond.Stereo.UP) continue;
                                sorted[sorted.length - 1] = chiralNeighbours.get(i17);
                            }
                            Object[] ohere = hm.values().toArray();
                            for (int i18 = 0; i18 < ohere.length; ++i18) {
                                sorted[i18] = chiralNeighbours.get((Integer)ohere[i18]);
                            }
                        }
                        if (container.getBond(parent, atom).getStereo() == null || container.getBond(parent, atom).getStereo() == IBond.Stereo.NONE) {
                            for (int i19 = 0; i19 < chiralNeighbours.size(); ++i19) {
                                if (chiralNeighbours.get(i19) == parent) continue;
                                if (container.getBond(atom, chiralNeighbours.get(i19)).getStereo() == null || container.getBond(atom, chiralNeighbours.get(i19)).getStereo() == IBond.Stereo.NONE) {
                                    hm.put(new Double(BondTools.giveAngleFromMiddle(atom, parent, chiralNeighbours.get(i19))), i19);
                                }
                                if (container.getBond(atom, chiralNeighbours.get(i19)).getStereo() == IBond.Stereo.UP) {
                                    sorted[0] = chiralNeighbours.get(i19);
                                }
                                if (container.getBond(atom, chiralNeighbours.get(i19)).getStereo() != IBond.Stereo.DOWN) continue;
                                sorted[sorted.length - 2] = chiralNeighbours.get(i19);
                            }
                            Object[] ohere = hm.values().toArray();
                            sorted[sorted.length - 1] = chiralNeighbours.get((Integer)ohere[ohere.length - 1]);
                            if (ohere.length == 2) {
                                sorted[sorted.length - 3] = chiralNeighbours.get((Integer)ohere[0]);
                                if (BondTools.giveAngleFromMiddle(atom, parent, chiralNeighbours.get((Integer)ohere[1])) < 0.0) {
                                    IAtom dummy = sorted[sorted.length - 2];
                                    sorted[sorted.length - 2] = sorted[0];
                                    sorted[0] = dummy;
                                }
                            }
                            if (ohere.length == 3) {
                                sorted[sorted.length - 3] = sorted[sorted.length - 2];
                                sorted[sorted.length - 2] = chiralNeighbours.get((Integer)ohere[ohere.length - 2]);
                                sorted[sorted.length - 4] = chiralNeighbours.get((Integer)ohere[ohere.length - 3]);
                            }
                        }
                    }
                    if (sorted != null) {
                        int k;
                        int numberOfAtoms = 3;
                        if (BondTools.isTrigonalBipyramidalOrOctahedral(container, atom) != 0) {
                            numberOfAtoms = container.getConnectedAtomsCount(atom) - 1;
                        }
                        Object[] omy = new Object[numberOfAtoms];
                        Object[] onew = new Object[numberOfAtoms];
                        for (k = this.getRingOpenings(atom, null).size(); k < numberOfAtoms; ++k) {
                            if (positionInVector + 1 + k - this.getRingOpenings(atom, null).size() >= v.size()) continue;
                            omy[k] = v.get(positionInVector + 1 + k - this.getRingOpenings(atom, null).size());
                        }
                        for (k = 0; k < sorted.length; ++k) {
                            if (sorted[k] != null) {
                                for (int m = 0; m < omy.length; ++m) {
                                    if (omy[m] instanceof IAtom) {
                                        if (omy[m] != sorted[k]) continue;
                                        onew[k] = omy[m];
                                        continue;
                                    }
                                    if (omy[m] == null) {
                                        onew[k] = null;
                                        continue;
                                    }
                                    if (((List)omy[m]).get(0) != sorted[k]) continue;
                                    onew[k] = omy[m];
                                }
                                continue;
                            }
                            onew[k] = null;
                        }
                        boolean doubleentry = false;
                        for (int m = 0; m < onew.length; ++m) {
                            for (int k2 = 0; k2 < onew.length; ++k2) {
                                if (m == k2 || onew[k2] != onew[m]) continue;
                                doubleentry = true;
                            }
                        }
                        if (!doubleentry) {
                            if (positionInVector + 1 < v.size()) {
                                Object atomAfterCenterInOriginalSmiles = v.get(positionInVector + 1);
                                int l = 0;
                                while (onew[0] != atomAfterCenterInOriginalSmiles) {
                                    Object placeholder = onew[onew.length - 1];
                                    for (int k3 = onew.length - 2; k3 > -1; --k3) {
                                        onew[k3 + 1] = onew[k3];
                                    }
                                    onew[0] = placeholder;
                                    if (++l <= onew.length) continue;
                                    break;
                                }
                            }
                            if (this.getRingOpenings(atom, null).size() > 0) {
                                int l = 0;
                                while (onew[0] != null) {
                                    Object placeholder = onew[0];
                                    for (int k4 = 1; k4 < onew.length; ++k4) {
                                        onew[k4 - 1] = onew[k4];
                                    }
                                    onew[onew.length - 1] = placeholder;
                                    if (++l <= onew.length) continue;
                                    break;
                                }
                            }
                            if (onew[numberOfAtoms - 1] instanceof List) {
                                for (int i20 = 0; i20 < numberOfAtoms; ++i20) {
                                    int k5;
                                    if (!(onew[i20] instanceof IAtom)) continue;
                                    Vector<Object> vtemp = new Vector<Object>();
                                    vtemp.add(onew[i20]);
                                    for (k5 = positionInVector + 1 + numberOfAtoms; k5 < v.size(); ++k5) {
                                        vtemp.add(v.get(k5));
                                    }
                                    onew[i20] = vtemp;
                                    for (k5 = v.size() - 1; k5 > positionInVector + 1 + numberOfAtoms - 1; --k5) {
                                        v.remove(k5);
                                    }
                                    for (k5 = 1; k5 < ((List)onew[numberOfAtoms - 1]).size(); ++k5) {
                                        v.add(((List)onew[numberOfAtoms - 1]).get(k5));
                                    }
                                    onew[numberOfAtoms - 1] = ((List)onew[numberOfAtoms - 1]).get(0);
                                    break;
                                }
                            }
                            int k6 = 0;
                            for (int m = 0; m < onew.length; ++m) {
                                if (onew[m] == null) continue;
                                v.set(positionInVector + 1 + k6, onew[m]);
                                ++k6;
                            }
                        }
                    }
                }
                parent = atom;
            } else {
                boolean brackets = true;
                Vector result = new Vector();
                this.addAtoms((List)o, result);
                IAtom prevAtom = (IAtom)((Vector)atomsInOrderOfSmiles).lastElement();
                int maxConnectedBondCount = 4;
                if (atomsInOrderOfSmiles.indexOf(parent) == 0 && prevAtom == parent) {
                    maxConnectedBondCount = 3;
                }
                if (this.isRingOpening(parent, result) && container.getConnectedBondsCount(parent) < maxConnectedBondCount) {
                    brackets = false;
                }
                if (brackets) {
                    buffer.append('(');
                }
                this.parseChain((List)o, buffer, container, parent, chiral, doubleBondConfiguration, atomsInOrderOfSmiles, useAromaticity);
                if (brackets) {
                    buffer.append(')');
                }
            }
            ++positionInVector;
        }
    }

    private void parseBond(StringBuffer line, IAtom a1, IAtom a2, IAtomContainer atomContainer, boolean useAromaticity) {
        if (useAromaticity && a1.getFlag(32) && a2.getFlag(32)) {
            return;
        }
        if (atomContainer.getBond(a1, a2) == null) {
            return;
        }
        IBond.Order type = atomContainer.getBond(a1, a2).getOrder();
        if (type != IBond.Order.SINGLE) {
            if (type == IBond.Order.DOUBLE) {
                line.append("=");
            } else if (type == IBond.Order.TRIPLE) {
                line.append("#");
            }
        }
    }

    private void parseAtom(IAtom a, StringBuffer buffer, IAtomContainer container, boolean chiral, boolean[] doubleBondConfiguration, IAtom parent, List atomsInOrderOfSmiles, List currentChain, boolean useAromaticity) {
        String mass;
        String symbol = a.getSymbol();
        if (a instanceof IPseudoAtom) {
            symbol = "*";
        }
        boolean stereo = false;
        if (chiral) {
            stereo = BondTools.isStereo(container, a);
        }
        boolean brackets = symbol.equals("B") || symbol.equals("C") || symbol.equals("N") || symbol.equals("O") || symbol.equals("P") || symbol.equals("S") || symbol.equals("F") || symbol.equals("Br") || symbol.equals("I") || symbol.equals("Cl");
        boolean bl = brackets = !brackets;
        if (chiral && this.isStartOfDoubleBond(container, a, parent, doubleBondConfiguration)) {
            buffer.append('/');
        }
        brackets |= !(mass = this.generateMassString(a)).equals("");
        String charge = this.generateChargeString(a);
        brackets |= !charge.equals("");
        if (chiral && stereo && (BondTools.isTrigonalBipyramidalOrOctahedral(container, a) != 0 || BondTools.isSquarePlanar(container, a) || BondTools.isTetrahedral(container, a, false) != 0 || BondTools.isSquarePlanar(container, a))) {
            brackets = true;
        }
        if (brackets) {
            buffer.append('[');
        }
        buffer.append(mass);
        if (useAromaticity && a.getFlag(32)) {
            if (a.getSymbol().equals("N") && a.getHybridization() == IAtomType.Hybridization.PLANAR3 && container.getConnectedAtomsList(a).size() != 3) {
                buffer.append("[").append(a.getSymbol().toLowerCase()).append("H]");
            } else {
                buffer.append(a.getSymbol().toLowerCase());
            }
        } else {
            buffer.append(symbol);
            if (symbol.equals("*") && a.getImplicitHydrogenCount() != null && a.getImplicitHydrogenCount() > 0) {
                buffer.append("H").append(a.getImplicitHydrogenCount());
            }
        }
        if (a.getProperty("stereoconfig") != null && a.getProperty("stereoconfig").equals("up")) {
            buffer.append('/');
        }
        if (a.getProperty("stereoconfig") != null && a.getProperty("stereoconfig").equals("down")) {
            buffer.append('\\');
        }
        if (chiral && stereo && (BondTools.isTrigonalBipyramidalOrOctahedral(container, a) != 0 || BondTools.isSquarePlanar(container, a) || BondTools.isTetrahedral(container, a, false) != 0)) {
            buffer.append('@');
        }
        if (chiral && stereo && BondTools.isSquarePlanar(container, a)) {
            buffer.append("SP1");
        }
        buffer.append(charge);
        if (brackets) {
            buffer.append(']');
        }
        if (chiral && this.isEndOfDoubleBond(container, a, parent, doubleBondConfiguration)) {
            int i;
            IAtom viewFrom = null;
            block2: for (i = 0; i < currentChain.size(); ++i) {
                if (currentChain.get(i) != parent) continue;
                for (int k = i - 1; k > -1; --k) {
                    if (!(currentChain.get(k) instanceof IAtom)) continue;
                    viewFrom = (IAtom)currentChain.get(k);
                    continue block2;
                }
            }
            if (viewFrom == null) {
                for (i = 0; i < atomsInOrderOfSmiles.size(); ++i) {
                    if (atomsInOrderOfSmiles.get(i) != parent) continue;
                    viewFrom = (IAtom)atomsInOrderOfSmiles.get(i - 1);
                }
            }
            boolean afterThisAtom = false;
            IAtom viewTo = null;
            for (int i2 = 0; i2 < currentChain.size(); ++i2) {
                if (afterThisAtom && currentChain.get(i2) instanceof IAtom) {
                    viewTo = (IAtom)currentChain.get(i2);
                    break;
                }
                if (afterThisAtom && currentChain.get(i2) instanceof List) {
                    viewTo = (IAtom)((List)currentChain.get(i2)).get(0);
                    break;
                }
                if (a != currentChain.get(i2)) continue;
                afterThisAtom = true;
            }
            try {
                if (BondTools.isCisTrans(viewFrom, a, parent, viewTo, container)) {
                    buffer.append('\\');
                } else {
                    buffer.append('/');
                }
            }
            catch (CDKException ex) {
                // empty catch block
            }
        }
        Vector v = new Vector();
        Iterator it = this.getRingOpenings(a, v).iterator();
        Iterator it2 = v.iterator();
        while (it.hasNext()) {
            Integer integer = (Integer)it.next();
            IAtom a2 = (IAtom)it2.next();
            IBond b = container.getBond(a2, a);
            IBond.Order type = b.getOrder();
            if (!(useAromaticity && a.getFlag(32) && a2.getFlag(32))) {
                if (type == IBond.Order.DOUBLE) {
                    buffer.append("=");
                } else if (type == IBond.Order.TRIPLE) {
                    buffer.append("#");
                }
            }
            if (integer >= 10) {
                buffer.append("%" + integer);
                continue;
            }
            buffer.append(integer);
        }
        atomsInOrderOfSmiles.add(a);
    }

    private String generateChargeString(IAtom a) {
        int charge = a.getFormalCharge() == CDKConstants.UNSET ? 0 : a.getFormalCharge();
        StringBuffer buffer = new StringBuffer(3);
        if (charge > 0) {
            buffer.append('+');
            if (charge > 1) {
                buffer.append(charge);
            }
        } else if (charge < 0) {
            if (charge == -1) {
                buffer.append('-');
            } else {
                buffer.append(charge);
            }
        }
        return buffer.toString();
    }

    private String generateMassString(IAtom a) {
        if (this.isotopeFactory == null) {
            this.setupIsotopeFactory(a.getBuilder());
        }
        if (a instanceof IPseudoAtom) {
            if (a.getMassNumber() != null) {
                return Integer.toString(a.getMassNumber());
            }
            return "";
        }
        IIsotope majorIsotope = this.isotopeFactory.getMajorIsotope(a.getSymbol());
        if (majorIsotope == null || majorIsotope.getMassNumber() == a.getMassNumber()) {
            return "";
        }
        if (a.getMassNumber() == null) {
            return "";
        }
        return Integer.toString(a.getMassNumber());
    }

    private void setupIsotopeFactory(IChemObjectBuilder builder) {
        try {
            this.isotopeFactory = IsotopeFactory.getInstance(builder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public AllRingsFinder getRingFinder() {
        return this.ringFinder;
    }

    public void setRingFinder(AllRingsFinder ringFinder) {
        this.ringFinder = ringFinder;
    }

    @TestMethod(value="testSFBug956923")
    public void setUseAromaticityFlag(boolean useAromaticityFlag) {
        this.useAromaticityFlag = useAromaticityFlag;
    }

    class BrokenBond {
        private IAtom a1;
        private IAtom a2;
        private int marker;

        BrokenBond(IAtom a1, IAtom a2, int marker) {
            this.a1 = a1;
            this.a2 = a2;
            this.marker = marker;
        }

        public IAtom getA1() {
            return this.a1;
        }

        public IAtom getA2() {
            return this.a2;
        }

        public int getMarker() {
            return this.marker;
        }

        public String toString() {
            return Integer.toString(this.marker);
        }

        public boolean equals(Object o) {
            if (!(o instanceof BrokenBond)) {
                return false;
            }
            BrokenBond bond = (BrokenBond)o;
            return this.a1.equals(bond.getA1()) && this.a2.equals(bond.getA2()) || this.a1.equals(bond.getA2()) && this.a2.equals(bond.getA1());
        }
    }
}

