/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.reaction.type.SharingAnionReactionTest")
public class SharingAnionReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(SharingAnionReaction.class);

    @TestMethod(value="testGetSpecification")
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#SharingAnion", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @TestMethod(value="testInitiate_IAtomContainerSet_IAtomContainerSet")
    public IReactionSet initiate(IAtomContainerSet reactants, IAtomContainerSet agents) throws CDKException {
        logger.debug("initiate reaction: SharingAnionReaction");
        if (reactants.getAtomContainerCount() != 1) {
            throw new CDKException("SharingAnionReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("SharingAnionReaction don't expects agents");
        }
        IReactionSet setOfReactions = reactants.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IAtomContainer reactant = reactants.getAtomContainer(0);
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        for (IAtom atomi : reactant.atoms()) {
            if (!atomi.getFlag(1024) || atomi.getFormalCharge() != -1 || reactant.getConnectedSingleElectronsCount(atomi) != 0 || reactant.getConnectedLonePairsList(atomi).size() <= 0) continue;
            for (IBond bondi : reactant.getConnectedBondsList(atomi)) {
                IAtom atomj;
                if (!bondi.getFlag(1024) || bondi.getOrder() != IBond.Order.SINGLE || !(atomj = bondi.getConnectedAtom(atomi)).getFlag(1024) || atomj.getFormalCharge() != 1 || reactant.getConnectedSingleElectronsCount(atomj) != 0) continue;
                ArrayList<IAtom> atomList = new ArrayList<IAtom>();
                atomList.add(atomi);
                atomList.add(atomj);
                ArrayList<IBond> bondList = new ArrayList<IBond>();
                bondList.add(bondi);
                IAtomContainerSet moleculeSet = reactant.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                moleculeSet.addAtomContainer(reactant);
                IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, bondList);
                if (reaction == null) continue;
                setOfReactions.addReaction(reaction);
            }
        }
        return setOfReactions;
    }

    private void setActiveCenters(IAtomContainer reactant) throws CDKException {
        for (IAtom atomi : reactant.atoms()) {
            if (atomi.getFormalCharge() != -1 || reactant.getConnectedSingleElectronsCount(atomi) != 0 || reactant.getConnectedLonePairsList(atomi).size() <= 0) continue;
            for (IBond bondi : reactant.getConnectedBondsList(atomi)) {
                IAtom atomj;
                if (bondi.getOrder() != IBond.Order.SINGLE || (atomj = bondi.getConnectedAtom(atomi)).getFormalCharge() != 1 || reactant.getConnectedSingleElectronsCount(atomj) != 0) continue;
                atomi.setFlag(1024, true);
                atomj.setFlag(1024, true);
                bondi.setFlag(1024, true);
            }
        }
    }
}

