/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.IChemObjectReaderErrorHandler;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.ReaderEvent;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.listener.IReaderListener;
import org.openscience.cdk.io.setting.IOSetting;

public abstract class DefaultChemObjectReader
implements ISimpleChemObjectReader {
    private ReaderEvent frameReadEvent = null;
    protected IChemObjectReader.Mode mode = IChemObjectReader.Mode.RELAXED;
    protected IChemObjectReaderErrorHandler errorHandler = null;
    private List<IChemObjectIOListener> listenerList = new ArrayList<IChemObjectIOListener>(2);

    @Override
    public void addChemObjectIOListener(IChemObjectIOListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeChemObjectIOListener(IChemObjectIOListener listener) {
        this.listenerList.remove(listener);
    }

    protected void fireFrameRead() {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            IChemObjectIOListener listener = this.listenerList.get(i);
            if (!(listener instanceof IReaderListener)) continue;
            if (this.frameReadEvent == null) {
                this.frameReadEvent = new ReaderEvent(this);
            }
            ((IReaderListener)listener).frameRead(this.frameReadEvent);
        }
    }

    protected void fireIOSettingQuestion(IOSetting setting) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            IChemObjectIOListener listener = this.listenerList.get(i);
            listener.processIOSettingQuestion(setting);
        }
    }

    @Override
    public IOSetting[] getIOSettings() {
        return new IOSetting[0];
    }

    @Override
    public void setReaderMode(IChemObjectReader.Mode mode) {
        this.mode = mode;
    }

    @Override
    public void setErrorHandler(IChemObjectReaderErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void handleError(String message) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message);
        }
    }

    @Override
    public void handleError(String message, Exception exception) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message, exception);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message, exception);
        }
    }

    @Override
    public void handleError(String message, int row, int colStart, int colEnd) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message, row, colStart, colEnd);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message);
        }
    }

    @Override
    public void handleError(String message, int row, int colStart, int colEnd, Exception exception) throws CDKException {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(message, row, colStart, colEnd, exception);
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException(message, exception);
        }
    }
}

