/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.text.ParseException;
import nu.xom.Element;
import nu.xom.Node;
import org.apache.log4j.Logger;
import org.xmlcml.cml.attribute.DictRefAttribute;
import org.xmlcml.cml.attribute.NamespaceRefAttribute;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.element.AbstractScalar;
import org.xmlcml.cml.interfacex.HasScalar;
import org.xmlcml.cml.interfacex.HasUnits;

public class CMLScalar
extends AbstractScalar
implements HasUnits,
HasScalar {
    public static final String NS = "cml:scalar";
    static final Logger logger = Logger.getLogger(CMLScalar.class);

    public CMLScalar() {
        this.init();
    }

    void init() {
    }

    public CMLScalar(CMLScalar old) {
        super(old);
    }

    public Node copy() {
        return new CMLScalar(this);
    }

    public CMLElement makeElementInContext(Element parent) {
        return new CMLScalar();
    }

    public void finishMakingElement(Element parent) throws RuntimeException {
        String dataType = this.getDataType();
        if (!dataType.equals("xsd:string")) {
            if (dataType.equals("xsd:boolean")) {
                this.getDouble();
            } else if ("xsd:double".equals(CMLType.getNormalizedValue(dataType))) {
                this.getDouble();
            } else if (dataType.equals("xsd:integer")) {
                this.getInt();
            } else if (dataType.equals("xsd:date")) {
                System.out.println("skipped date");
            } else {
                throw new RuntimeException("scalar does not support dataType: " + dataType);
            }
        }
    }

    public CMLScalar(String scalar) {
        this.setValue(scalar);
    }

    public CMLScalar(double scalar) {
        this.setValue(scalar);
    }

    public CMLScalar(int scalar) {
        this.setValue(scalar);
    }

    public double getDouble() {
        String content;
        double result = Double.NaN;
        if (this.getDataType().equals("xsd:double") && (content = this.getXMLContent()) != null) {
            try {
                result = CMLUtil.parseFlexibleDouble(content);
            }
            catch (ParseException e) {
                throw new RuntimeException("Bad double :" + content, e);
            }
        }
        return result;
    }

    public String getString() {
        String result = null;
        if (this.getDataType().equals("xsd:string")) {
            result = this.getXMLContent();
        }
        return result;
    }

    public int getInt() {
        int result = Integer.MIN_VALUE;
        if (this.getDataType().equals("xsd:integer")) {
            String content = this.getXMLContent();
            if (content != null && !content.trim().equals("")) {
                try {
                    result = Integer.parseInt(content);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("bad integer content: " + content);
                }
            }
        } else {
            throw new RuntimeException("wrong dataType for int " + this.getDataType());
        }
        return result;
    }

    public void setValue(String scalar) {
        if (scalar != null) {
            this.setXMLContent(scalar);
            super.setDataType("xsd:string");
        }
    }

    public void setValue(double scalar) {
        this.setXMLContent("" + scalar);
        super.setDataType("xsd:double");
    }

    public void setValue(int scalar) {
        this.setXMLContent("" + scalar);
        super.setDataType("xsd:integer");
    }

    public String getDataType() {
        String dataType = super.getDataType();
        if (dataType == null) {
            dataType = "xsd:string";
            super.setDataType(dataType);
        }
        return CMLType.getNormalizedValue(dataType);
    }

    public void setDataType(String dType) {
        if (this.getAttributeValue("dataType") != null) {
            throw new RuntimeException("Must not reset dataType; use SetValue(...)");
        }
        super.setDataType(dType);
    }

    void checkNumericConformability(CMLScalar scalar) {
        if (!this.getDataType().equals(scalar.getDataType())) {
            throw new RuntimeException("Unsuitable dataTypes for numeric operations / " + this.getDataType() + "/" + scalar.getDataType());
        }
    }

    public CMLScalar subtract(CMLScalar scalar) {
        this.checkNumericConformability(scalar);
        CMLScalar resultScalar = null;
        if (this.getDataType().equals("xsd:double")) {
            resultScalar = new CMLScalar(this.getDouble() - scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            resultScalar = new CMLScalar(this.getInt() - scalar.getInt());
        }
        return resultScalar;
    }

    public void subtractEquals(CMLScalar scalar) {
        this.checkNumericConformability(scalar);
        if (this.getDataType().equals("xsd:double")) {
            this.setValue(this.getDouble() - scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            this.setValue(this.getInt() - scalar.getInt());
        }
    }

    public CMLScalar plus(CMLScalar scalar) {
        this.checkNumericConformability(scalar);
        CMLScalar resultScalar = null;
        if (this.getDataType().equals("xsd:double")) {
            resultScalar = new CMLScalar(this.getDouble() + scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            resultScalar = new CMLScalar(this.getInt() + scalar.getInt());
        }
        return resultScalar;
    }

    public void plusEquals(CMLScalar scalar) {
        this.checkNumericConformability(scalar);
        if (this.getDataType().equals("xsd:double")) {
            this.setValue(this.getDouble() + scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            this.setValue(this.getInt() + scalar.getInt());
        }
    }

    public DictRefAttribute getDictRefFromElementOrParent() {
        return DictRefAttribute.getDictRefFromElementOrParent(this);
    }

    public void setUnits(String prefix, String id, String namespaceURI) {
        NamespaceRefAttribute.setUnits(this, prefix, id, namespaceURI);
    }
}

