/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.interfaces.IAtom;

public class ChangeCoordsEdit
implements IUndoRedoable {
    private static final long serialVersionUID = -8964120764568614909L;
    private Map<IAtom, Point2d[]> atomCoordsMap;
    private String type;

    public ChangeCoordsEdit(Map<IAtom, Point2d[]> atomCoordsMap, String type) {
        this.atomCoordsMap = atomCoordsMap;
        this.type = type;
    }

    @Override
    public void redo() {
        Set<IAtom> keys = this.atomCoordsMap.keySet();
        for (IAtom atom : keys) {
            Point2d[] coords = this.atomCoordsMap.get(atom);
            atom.setNotification(false);
            atom.setPoint2d(coords[0]);
            atom.setNotification(true);
        }
    }

    @Override
    public void undo() {
        Set<IAtom> keys = this.atomCoordsMap.keySet();
        for (IAtom atom : keys) {
            Point2d[] coords = this.atomCoordsMap.get(atom);
            atom.setPoint2d(coords[1]);
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

