/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.SpanningTree;
import org.openscience.cdk.graph.matrix.ConnectionMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.LongestAliphaticChainDescriptorTest")
public class LongestAliphaticChainDescriptor
implements IMolecularDescriptor {
    private boolean checkRingSystem = false;
    private static final String[] names = new String[]{"nAtomLAC"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#longestAliphaticChain", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("LongestAliphaticChainDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("Both parameters must be of type Boolean");
        }
        this.checkRingSystem = (Boolean)params[0];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkRingSystem};
        return params;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), e);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        int i;
        IAtomContainer container;
        try {
            container = (IAtomContainer)atomContainer.clone();
            container = AtomContainerManipulator.removeHydrogens(container);
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames());
        }
        if (this.checkRingSystem) {
            IRingSet rs;
            try {
                rs = new SpanningTree(container).getBasicRings();
            }
            catch (NoSuchAtomException e) {
                return this.getDummyDescriptorValue(e);
            }
            for (int i2 = 0; i2 < container.getAtomCount(); ++i2) {
                if (!rs.contains(container.getAtom(i2))) continue;
                container.getAtom(i2).setFlag(1, true);
            }
        }
        int longestChainAtomsCount = 0;
        for (i = 0; i < container.getAtomCount(); ++i) {
            container.getAtom(i).setFlag(4, false);
        }
        for (i = 0; i < container.getAtomCount(); ++i) {
            double[][] conMat;
            int[][] apsp;
            int tmpLongestChainAtomCount;
            IAtom atomi = container.getAtom(i);
            if (atomi.getSymbol().equals("H") || !((!atomi.getFlag(5) && !atomi.getFlag(1) & atomi.getSymbol().equals("C")) & !atomi.getFlag(4))) continue;
            ArrayList<IAtom> startSphere = new ArrayList<IAtom>();
            ArrayList<IAtom> path = new ArrayList<IAtom>();
            startSphere.add(atomi);
            try {
                this.breadthFirstSearch(container, startSphere, path);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
            IAtomContainer aliphaticChain = this.createAtomContainerFromPath(container, path);
            if (aliphaticChain.getAtomCount() <= 1 || (tmpLongestChainAtomCount = this.getLongestChainPath(apsp = PathTools.computeFloydAPSP(conMat = ConnectionMatrix.getMatrix(aliphaticChain)))) <= longestChainAtomsCount) continue;
            longestChainAtomsCount = tmpLongestChainAtomCount;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(longestChainAtomsCount), this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    private int getLongestChainPath(int[][] apsp) {
        int longestPath = 0;
        for (int i = 0; i < apsp.length; ++i) {
            for (int j = 0; j < apsp.length; ++j) {
                if (apsp[i][j] + 1 <= longestPath) continue;
                longestPath = apsp[i][j] + 1;
            }
        }
        return longestPath;
    }

    private IAtomContainer createAtomContainerFromPath(IAtomContainer container, List<IAtom> path) {
        IAtomContainer aliphaticChain = DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, new Object[0]);
        for (int i = 0; i < path.size() - 1; ++i) {
            if (!aliphaticChain.contains(path.get(i))) {
                aliphaticChain.addAtom(path.get(i));
            }
            for (int j = 1; j < path.size(); ++j) {
                if (container.getBond(path.get(i), path.get(j)) == null) continue;
                if (!aliphaticChain.contains(path.get(j))) {
                    aliphaticChain.addAtom(path.get(j));
                }
                aliphaticChain.addBond(container.getBond(path.get(i), path.get(j)));
            }
        }
        if (aliphaticChain.getBondCount() == 0) {
            aliphaticChain.removeAllElements();
        }
        return aliphaticChain;
    }

    private void breadthFirstSearch(IAtomContainer container, List<IAtom> sphere, List<IAtom> path) throws CDKException {
        ArrayList<IAtom> newSphere = new ArrayList<IAtom>();
        for (IAtom atom : sphere) {
            List<IBond> bonds = container.getConnectedBondsList(atom);
            for (IBond bond : bonds) {
                IAtom nextAtom = bond.getConnectedAtom(atom);
                if ((!nextAtom.getFlag(5) && !nextAtom.getFlag(1) & nextAtom.getSymbol().equals("C")) & !nextAtom.getFlag(4)) {
                    path.add(nextAtom);
                    nextAtom.setFlag(4, true);
                    if (container.getConnectedBondsCount(nextAtom) <= 1) continue;
                    newSphere.add(nextAtom);
                    continue;
                }
                nextAtom.setFlag(4, true);
            }
        }
        if (newSphere.size() > 0) {
            this.breadthFirstSearch(container, newSphere, path);
        }
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"checkRingSystem"};
        return params;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return true;
    }
}

