/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.ConnectionMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class EquivalentClassPartitioner {
    private double[][] nodeMatrix;
    private double[][] bondMatrix;
    private double[] weight;
    private double[][] adjaMatrix;
    private int[][] apspMatrix;
    private int layerNumber;
    private int nodeNumber;
    private static double LOST = 1.0E-12;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(EquivalentClassPartitioner.class);

    public EquivalentClassPartitioner() {
    }

    public EquivalentClassPartitioner(AtomContainer atomContainer) {
        this.adjaMatrix = ConnectionMatrix.getMatrix(atomContainer);
        this.apspMatrix = PathTools.computeFloydAPSP(this.adjaMatrix);
        this.layerNumber = 1;
        this.nodeNumber = atomContainer.getAtomCount();
        for (int i = 1; i < atomContainer.getAtomCount(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.apspMatrix[i][j] <= this.layerNumber) continue;
                this.layerNumber = this.apspMatrix[i][j];
            }
        }
        this.nodeMatrix = new double[this.nodeNumber][this.layerNumber + 1];
        this.bondMatrix = new double[this.nodeNumber][this.layerNumber];
        this.weight = new double[this.nodeNumber + 1];
    }

    public int[] getTopoEquivClassbyHuXu(AtomContainer atomContainer) throws NoSuchAtomException {
        double[] nodeSequence = this.prepareNode(atomContainer);
        this.nodeMatrix = this.buildNodeMatrix(nodeSequence);
        this.bondMatrix = this.buildBondMatrix();
        this.weight = this.buildWeightMatrix(this.nodeMatrix, this.bondMatrix);
        int[] AutomorphismPartition = this.findTopoEquivClass(this.weight);
        return AutomorphismPartition;
    }

    public double[] prepareNode(AtomContainer atomContainer) {
        Iterator<IAtom> atoms = atomContainer.atoms().iterator();
        double[] nodeSequence = new double[atomContainer.getAtomCount()];
        int i = 0;
        while (atoms.hasNext()) {
            IBond bond1;
            IBond bond0;
            IAtom atom = atoms.next();
            List<IBond> bonds = atomContainer.getConnectedBondsList(atom);
            if (bonds.size() == 1) {
                bond0 = bonds.get(0);
                if (atom.getSymbol().equals("C")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 1.0;
                    } else if (bond0.getOrder() == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 3.0;
                    } else if (bond0.getOrder() == IBond.Order.TRIPLE) {
                        nodeSequence[i] = 6.0;
                    }
                } else if (atom.getSymbol().equals("O")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 14.0;
                    } else if (bond0.getOrder() == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 16.0;
                    }
                } else if (atom.getSymbol().equals("N")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 18.0;
                    } else if (bond0.getOrder() == IBond.Order.DOUBLE) {
                        nodeSequence[i] = atom.getCharge() == -1.0 ? 27.0 : 20.0;
                    } else if (bond0.getOrder() == IBond.Order.TRIPLE) {
                        nodeSequence[i] = 23.0;
                    }
                } else if (atom.getSymbol().equals("S")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 31.0;
                    } else if (bond0.getOrder() == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 33.0;
                    }
                } else if (atom.getSymbol().equals("P")) {
                    nodeSequence[i] = 38.0;
                } else if (atom.getSymbol().equals("F")) {
                    nodeSequence[i] = 42.0;
                } else if (atom.getSymbol().equals("Cl")) {
                    nodeSequence[i] = 43.0;
                } else if (atom.getSymbol().equals("Br")) {
                    nodeSequence[i] = 44.0;
                } else if (atom.getSymbol().equals("I")) {
                    nodeSequence[i] = 45.0;
                } else {
                    logger.debug("in case of a new node, please report this bug to cdk-devel@lists.sf.net.");
                }
            } else if (bonds.size() == 2) {
                bond0 = bonds.get(0);
                bond1 = bonds.get(1);
                if (atom.getSymbol().equals("C")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE && bond1.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 2.0;
                    } else if (bond0.getOrder() == IBond.Order.DOUBLE && bond1.getOrder() == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 10.0;
                    } else if (!(bond0.getOrder() != IBond.Order.SINGLE && bond1.getOrder() != IBond.Order.SINGLE || bond0.getOrder() != IBond.Order.DOUBLE && bond1.getOrder() != IBond.Order.DOUBLE)) {
                        nodeSequence[i] = 5.0;
                    } else if (!(bond0.getOrder() != IBond.Order.SINGLE && bond1.getOrder() != IBond.Order.TRIPLE || bond0.getOrder() != IBond.Order.TRIPLE && bond1.getOrder() != IBond.Order.TRIPLE)) {
                        nodeSequence[i] = 9.0;
                    } else if (bond0.getFlag(5) && bond1.getFlag(5)) {
                        nodeSequence[i] = 11.0;
                    }
                } else if (atom.getSymbol().equals("N")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE && bond1.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 19.0;
                    } else if (bond0.getOrder() == IBond.Order.DOUBLE && bond1.getOrder() == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 28.0;
                    } else if (!(bond0.getOrder() != IBond.Order.SINGLE && bond1.getOrder() != IBond.Order.SINGLE || bond0.getOrder() != IBond.Order.DOUBLE && bond1.getOrder() != IBond.Order.DOUBLE)) {
                        nodeSequence[i] = 22.0;
                    } else if (!(bond0.getOrder() != IBond.Order.DOUBLE && bond1.getOrder() != IBond.Order.DOUBLE || bond0.getOrder() != IBond.Order.TRIPLE && bond1.getOrder() != IBond.Order.TRIPLE)) {
                        nodeSequence[i] = 26.0;
                    } else if (!(bond0.getOrder() != IBond.Order.SINGLE && bond1.getOrder() != IBond.Order.SINGLE || bond0.getOrder() != IBond.Order.TRIPLE && bond1.getOrder() != IBond.Order.TRIPLE)) {
                        nodeSequence[i] = 29.0;
                    } else if (bond0.getFlag(5) && bond1.getFlag(5)) {
                        nodeSequence[i] = 30.0;
                    }
                } else if (atom.getSymbol().equals("O")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE && bond1.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 15.0;
                    } else if (bond0.getFlag(5) && bond1.getFlag(5)) {
                        nodeSequence[i] = 17.0;
                    }
                } else if (atom.getSymbol().equals("S")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE && bond1.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 32.0;
                    } else if (bond0.getOrder() == IBond.Order.DOUBLE && bond1.getOrder() == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 35.0;
                    } else if (bond0.getFlag(5) && bond1.getFlag(5)) {
                        nodeSequence[i] = 37.0;
                    }
                } else if (atom.getSymbol().equals("P")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE && bond1.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 39.0;
                    }
                } else {
                    logger.debug("in case of a new node, please report this bug to cdk-devel@lists.sf.net.");
                }
            } else if (bonds.size() == 3) {
                bond0 = bonds.get(0);
                bond1 = bonds.get(1);
                IBond bond2 = bonds.get(2);
                if (atom.getSymbol().equals("C")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE && bond1.getOrder() == IBond.Order.SINGLE && bond2.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 4.0;
                    } else if (bond0.getOrder() == IBond.Order.DOUBLE || bond1.getOrder() == IBond.Order.DOUBLE || bond2.getOrder() == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 8.0;
                    } else if (bond0.getFlag(5) && bond1.getFlag(5) && bond2.getFlag(5)) {
                        nodeSequence[i] = 13.0;
                    } else if ((bond0.getFlag(5) || bond1.getFlag(5) || bond2.getFlag(5)) && (bond0.getOrder() == IBond.Order.SINGLE || bond1.getOrder() == IBond.Order.SINGLE || bond2.getOrder() == IBond.Order.SINGLE)) {
                        nodeSequence[i] = 12.0;
                    }
                } else if (atom.getSymbol().equals("N")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE && bond1.getOrder() == IBond.Order.SINGLE && bond2.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 21.0;
                    } else if (bond0.getOrder() == IBond.Order.SINGLE || bond1.getOrder() == IBond.Order.SINGLE || bond2.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 25.0;
                    }
                } else if (atom.getSymbol().equals("S")) {
                    if (bond0.getOrder() == IBond.Order.DOUBLE || bond1.getOrder() == IBond.Order.DOUBLE || bond2.getOrder() == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 34.0;
                    }
                } else if (atom.getSymbol().equals("P")) {
                    if (bond0.getOrder() == IBond.Order.SINGLE && bond1.getOrder() == IBond.Order.SINGLE && bond2.getOrder() == IBond.Order.SINGLE) {
                        nodeSequence[i] = 40.0;
                    }
                } else {
                    logger.debug("in case of a new node, please report this bug to cdk-devel@lists.sf.net.");
                }
            } else if (bonds.size() == 4) {
                if (atom.getSymbol().equals("C")) {
                    nodeSequence[i] = 7.0;
                } else if (atom.getSymbol().equals("N")) {
                    nodeSequence[i] = 24.0;
                } else if (atom.getSymbol().equals("S")) {
                    nodeSequence[i] = 36.0;
                } else if (atom.getSymbol().equals("P")) {
                    nodeSequence[i] = 41.0;
                } else {
                    logger.debug("in case of a new node, please report this bug to cdk-devel@lists.sf.net.");
                }
            }
            ++i;
        }
        return nodeSequence;
    }

    public double[][] buildNodeMatrix(double[] nodeSequence) {
        for (int i = 0; i < this.nodeNumber; ++i) {
            this.nodeMatrix[i][0] = nodeSequence[i];
            for (int j = 1; j <= this.layerNumber; ++j) {
                this.nodeMatrix[i][j] = 0.0;
                for (int k = 0; k < this.nodeNumber; ++k) {
                    if (this.apspMatrix[i][k] != j) continue;
                    double[] dArray = this.nodeMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + nodeSequence[k];
                }
            }
        }
        return this.nodeMatrix;
    }

    public double[][] buildTrialNodeMatrix(double[] weight) {
        for (int i = 0; i < this.nodeNumber; ++i) {
            this.nodeMatrix[i][0] = weight[i + 1];
            for (int j = 1; j <= this.layerNumber; ++j) {
                this.nodeMatrix[i][j] = 0.0;
                for (int k = 0; k < this.nodeNumber; ++k) {
                    if (this.apspMatrix[i][k] != j) continue;
                    double[] dArray = this.nodeMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + weight[k + 1];
                }
            }
        }
        return this.nodeMatrix;
    }

    public double[][] buildBondMatrix() {
        for (int i = 0; i < this.nodeNumber; ++i) {
            for (int j = 1; j <= this.layerNumber; ++j) {
                this.bondMatrix[i][j - 1] = 0.0;
                for (int k = 0; k < this.nodeNumber; ++k) {
                    if (j == 1) {
                        if (this.apspMatrix[i][k] != j) continue;
                        double[] dArray = this.bondMatrix[i];
                        int n = j - 1;
                        dArray[n] = dArray[n] + this.adjaMatrix[i][k];
                        continue;
                    }
                    if (this.apspMatrix[i][k] != j) continue;
                    for (int m = 0; m < this.nodeNumber; ++m) {
                        if (this.apspMatrix[i][m] != j - 1) continue;
                        double[] dArray = this.bondMatrix[i];
                        int n = j - 1;
                        dArray[n] = dArray[n] + this.adjaMatrix[k][m];
                    }
                }
            }
        }
        return this.bondMatrix;
    }

    public double[] buildWeightMatrix(double[][] nodeMatrix, double[][] bondMatrix) {
        for (int i = 0; i < this.nodeNumber; ++i) {
            this.weight[i + 1] = nodeMatrix[i][0];
            for (int j = 0; j < this.layerNumber; ++j) {
                int n = i + 1;
                this.weight[n] = this.weight[n] + nodeMatrix[i][j + 1] * bondMatrix[i][j] * Math.pow(10.0, -(j + 1));
            }
        }
        this.weight[0] = 0.0;
        return this.weight;
    }

    public int checkDiffNumber(double[] weight) {
        double[] category = new double[weight.length];
        int count = 1;
        category[1] = weight[1];
        for (int i = 2; i < weight.length; ++i) {
            int j;
            for (j = 1; j <= count; ++j) {
                double t = weight[i] - category[j];
                if (t < 0.0) {
                    t = -t;
                }
                if (t < LOST) break;
            }
            if (j <= count) continue;
            category[++count] = weight[i];
        }
        return count;
    }

    public int[] getEquivalentClass(double[] weight) {
        double t;
        int j;
        int i;
        double[] category = new double[weight.length];
        int[] equivalentClass = new int[weight.length];
        int count = 1;
        category[1] = weight[1];
        for (i = 2; i < weight.length; ++i) {
            for (j = 1; j <= count; ++j) {
                t = weight[i] - category[j];
                if (t < 0.0) {
                    t = -t;
                }
                if (t < LOST) break;
            }
            if (j <= count) continue;
            category[++count] = weight[i];
        }
        for (i = 1; i < weight.length; ++i) {
            for (j = 1; j <= count; ++j) {
                t = weight[i] - category[j];
                if (t < 0.0) {
                    t = -t;
                }
                if (!(t < LOST)) continue;
                equivalentClass[i] = j;
            }
        }
        equivalentClass[0] = count;
        return equivalentClass;
    }

    public int[] findTopoEquivClass(double[] weight) {
        int count;
        int[] equivalentClass = new int[weight.length];
        int trialCount = count = this.checkDiffNumber(weight);
        if (count == this.nodeNumber) {
            for (int i = 1; i <= this.nodeNumber; ++i) {
                equivalentClass[i] = i;
            }
            equivalentClass[0] = count;
            return equivalentClass;
        }
        do {
            count = trialCount;
            double[][] trialNodeMatrix = this.buildTrialNodeMatrix(weight);
            double[] trialWeight = this.buildWeightMatrix(trialNodeMatrix, this.bondMatrix);
            trialCount = this.checkDiffNumber(trialWeight);
            if (trialCount == this.nodeNumber) {
                for (int i = 1; i <= this.nodeNumber; ++i) {
                    equivalentClass[i] = i;
                }
                equivalentClass[0] = count;
                return equivalentClass;
            }
            if (trialCount > count) continue;
            equivalentClass = this.getEquivalentClass(weight);
            return equivalentClass;
        } while (trialCount > count);
        return equivalentClass;
    }
}

