% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_ifelse.R
\name{safe_ifelse}
\alias{safe_ifelse}
\title{A safe alternative to ifelse}
\usage{
safe_ifelse(test, yes, no, na_as_false = TRUE, drop.levels = TRUE)
}
\arguments{
\item{test, yes, no}{arguments passed to \code{\link{ifelse}}}

\item{na_as_false}{should \code{NA} values in \code{test} be handled as \code{FALSE}?
\code{TRUE} (which is default) implies that \code{test & !is.na(test)} must be fullfilled to
return values from argument \code{yes}}

\item{drop.levels}{This only applies when \code{yes} and \code{no} are factor variables. 
The result will then also be a factor. Unused levels (from \code{yes} and \code{no} combined)
are dropped by default.}
}
\value{
Vector of same length and class as \code{yes} and \code{no}.
}
\description{
This function is similair to \code{\link{ifelse}} with differences described in the details section.
}
\details{
\code{safe_ifelse} differs from \code{\link{ifelse}} in the following ways:
\itemize{
\item{Both 'yes' and 'no' must be vectors of the same type or class. 
This ensures that the output will be of correct format.}
\item{Factors can be combined without problem}
\item{The argument \code{na.rm} makes it easier to handle cases when \code{cond = NA}}
}
}
\examples{
# Test must be TRUE to return 'yes'
safe_ifelse(NA, 1, 2) ## 2
ifelse(NA, 1, 2) ## NA

# Factors are problematic in ifelse
ifelse(TRUE, as.factor("hello"), 2) ## 1
\dontrun{
safe_ifelse(TRUE, as.factor("hello"), 2) ## Error
}
safe_ifelse(TRUE, as.factor("hello"), as.factor(2)) ## hello
safe_ifelse(TRUE, as.factor("hello"), as.factor(2), drop.levels = FALSE)


}

