% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenith_azimuth_from_row_col.R
\name{zenith_azimuth_from_row_col}
\alias{zenith_azimuth_from_row_col}
\title{Obtain zenith and azimuth angles from row and col numbers}
\usage{
zenith_azimuth_from_row_col(z, a, row_col, lens_coef = NULL)
}
\arguments{
\item{z}{\linkS4class{SpatRaster} built with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{row_col}{Numeric vector of length two. Row and col numbers.}

\item{lens_coef}{Numeric vector. Polynomial coefficients of the lens
projection function. See \code{\link[=calibrate_lens]{calibrate_lens()}}.}
}
\value{
Numeric vector of length two.
}
\description{
Obtain zenith and azimuth angles from row and col numbers
}
\note{
Use the \code{lens_coef} argument to calculate coordinates below the horizon.
}
\examples{
z <- zenith_image(1000, lens())
a <- azimuth_image(z)
zenith_azimuth_from_row_col(z, a, c(501, 750))
}
\seealso{
Other HSP Functions: 
\code{\link{read_manual_input}()},
\code{\link{read_opt_sky_coef}()},
\code{\link{row_col_from_zenith_azimuth}()},
\code{\link{write_sky_points}()},
\code{\link{write_sun_coord}()}
}
\concept{HSP Functions}
