% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbc.R
\name{gbc}
\alias{gbc}
\title{Gamma back correction}
\usage{
gbc(DN_from_JPEG, gamma = 2.2)
}
\arguments{
\item{DN_from_JPEG}{Numeric vector or object from the
\code{\linkS4class{Raster}} class. Digital numbers from a JPEG file (0 to
255, the standard 8-bit encoded).}

\item{gamma}{Numeric vector of length one. Gamma value. Please see
\insertCite{Diaz2018;textual}{rcaiman} for details.}
}
\value{
The same class than \code{DN_from_JPEG}, with dimension unchanged but
  values rescaled between 0 and 1 in a non linear fashion.
}
\description{
Gamma back correction of JPEG images.
}
\examples{
r <- read_caim()
r
gbc(r)
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{normalize}}

Other Tools functions: 
\code{\link{apply_thr}()},
\code{\link{extract_feature}()},
\code{\link{masking}()},
\code{\link{normalize}()},
\code{\link{read_bin}()},
\code{\link{read_caim}()},
\code{\link{regional_thresholding}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tools functions}
