% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_predicted_sky.R
\name{fix_predicted_sky}
\alias{fix_predicted_sky}
\title{Fix predicted sky}
\usage{
fix_predicted_sky(sky, z, r, bin)
}
\arguments{
\item{sky}{\linkS4class{RasterLayer}. Sky DNs predicted with functions such
as \code{\link{fit_coneshaped_model}} and \code{\link{fit_trend_surface}}.}

\item{z}{\linkS4class{RasterLayer}. The result of a call to
\code{\link{zenith_image}}.}

\item{r}{\linkS4class{RasterLayer}. The source of the sky DNs used to build
\code{sky}.}

\item{bin}{\linkS4class{RasterLayer}. The binarization of \code{r} used to
select the sky DNs for building \code{sky}.}
}
\value{
An object of class \linkS4class{RasterLayer} that is an edited
  version of \code{sky}. Pixel dimensions should remain unchanged.
}
\description{
Automatically edit a raster image of sky digital numbers (DNs) predicted with
functions such as \code{\link{fit_coneshaped_model}} and
\code{\link{fit_trend_surface}}.
}
\details{
The predicted sky DNs are usually erroneous near the horizon because they are
a misleading extrapolation or are based on corrupted data (non-pure sky DNs).

This automatic edition consists of (1) flattening values below the minimum
input data (2) and forcing the values toward the horizon to gradually become
the median input data. The latter is achieved by calculating the weighted
average of the median value and the predicted sky DNs --\code{z / 90} is used
to determine the weights.
}
\examples{
\dontrun{
path <- system.file("external/4_D_2_DSCN4502.JPG", package = "rcaiman")
r <- read_caim(path, c(1280, 960) - 745, 745 * 2, 745 * 2)
z <- zenith_image(ncol(r), lens("Nikon_FCE9"))
a <- azimuth_image(z)
blue <- gbc(r$Blue)
bin <- find_sky_pixels(blue, z, a)
sky <- fit_coneshaped_model(blue, z, a, bin, parallel = FALSE)
sky <- fix_predicted_sky(sky$image, z, blue, bin)
persp(sky, theta = 90, phi = 0)
}
}
