% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc.R
\name{top.ranked.sets}
\alias{top.ranked.sets}
\title{Find k-top-ranked sets}
\usage{
top.ranked.sets(rankings, k.max, min.max.freq = 1, active = NULL)
}
\arguments{
\item{rankings}{Matrix with rankings in each column.}

\item{k.max}{Positive integer.}

\item{min.max.freq}{Maximum frequency.}

\item{active}{A vector with previously found active variables.}
}
\value{
List containing the following fields.
\item{frequencies}{Frequencies corresponding to the most frequent subsests at the top of the rankings.}
\item{subsets}{The moost frequent subsets.}
}
\description{
Finds k-top-ranked sets defined in Baranowski and Fryzlewicz (2015). This routine is used inside \code{\link{rbvs}}; it typically will be not called directly by the user.
}
\details{
Uses Portable qsort_r / qsort_s library ( Turner (2013)).
}
\references{
R. Baranowski, P. Fryzlewicz (2015), Ranking-Based Variable Selection, in submission (\url{http://personal.lse.ac.uk/baranows/rbvs/rbvs.pdf)}).\cr
I. Turner (2013), Portable qsort_r / qsort_s, GitHub repository (\url{https://github.com/noporpoise/sort_r}).
}

