% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_axis.R
\name{theme_axis}
\alias{theme_axis}
\title{Override theme parameters for axis attributes}
\usage{
theme_axis(fig, which = c("x", "y"), num_minor_ticks = 5,
  axis_label_standoff = NULL, axis_label_text_align = "left",
  axis_label_text_alpha = 1, axis_label_text_baseline = "bottom",
  axis_label_text_color = "#444444", axis_label_text_font = "Helvetica",
  axis_label_text_font_size = "12pt", axis_label_text_font_style = "normal",
  axis_line_alpha = 1, axis_line_cap = "butt", axis_line_color = "black",
  axis_line_dash = NULL, axis_line_dash_offset = 0,
  axis_line_join = "miter", axis_line_width = 1,
  major_label_orientation = "horizontal", major_label_standoff = NULL,
  major_label_text_align = "left", major_label_text_alpha = 1,
  major_label_text_baseline = "bottom", major_label_text_color = "#444444",
  major_label_text_font = "Helvetica", major_label_text_font_size = "12pt",
  major_label_text_font_style = "normal", major_tick_in = NULL,
  major_tick_line_alpha = 1, major_tick_line_cap = "butt",
  major_tick_line_color = "black", major_tick_line_dash = NULL,
  major_tick_line_dash_offset = 0, major_tick_line_join = "miter",
  major_tick_line_width = 1, major_tick_out = NULL, minor_tick_in = NULL,
  minor_tick_line_alpha = 1, minor_tick_line_cap = "butt",
  minor_tick_line_color = "black", minor_tick_line_dash = NULL,
  minor_tick_line_dash_offset = 0, minor_tick_line_join = "miter",
  minor_tick_line_width = 1, minor_tick_out = NULL, pars = NULL)
}
\arguments{
\item{fig}{figure to modify}

\item{which}{which grids to apply attributes to ("x" and/or "y")}

\item{num_minor_ticks}{number of minor ticks}

\item{axis_label_standoff}{(integer) The distance in pixels that the axis labels should be offset from the tick labels.}

\item{axis_label_text_align}{('left', 'right', 'center') The text align of the axis label.}

\item{axis_label_text_alpha}{(numeric) The text alpha of the axis label.}

\item{axis_label_text_baseline}{('top', 'middle', 'bottom', 'alphabetic', 'hanging') The text baseline of the axis label.}

\item{axis_label_text_color}{(color) The text color of the axis label.}

\item{axis_label_text_font}{(string) The text font of the axis label.}

\item{axis_label_text_font_size}{(string - e.g. '12pt') The text font size of the axis label.}

\item{axis_label_text_font_style}{('normal', 'italic', 'bold') The text font style of the axis label.}

\item{axis_line_alpha}{(numeric) The line alpha of the axis line.}

\item{axis_line_cap}{('butt', 'round', 'square') The line cap of the axis line.}

\item{axis_line_color}{(color) The line color of the axis line.}

\item{axis_line_dash}{The line dash of the axis line.}

\item{axis_line_dash_offset}{(integer) The line dash offset of the axis line.}

\item{axis_line_join}{('miter', 'round', 'bevel') The line join of the axis line.}

\item{axis_line_width}{(integer) The line width of the axis line.}

\item{major_label_orientation}{('horizontal', 'vertical', or angle in degrees) What direction the major label text should be oriented. If a number is supplied, the angle of the text is measured from horizontal.}

\item{major_label_standoff}{(integer) The distance in pixels that the major tick labels should be offset from the associated ticks.}

\item{major_label_text_align}{('left', 'right', 'center') The text align of the major tick labels.}

\item{major_label_text_alpha}{(numeric) The text alpha of the major tick labels.}

\item{major_label_text_baseline}{('top', 'middle', 'bottom', 'alphabetic', 'hanging') The text baseline of the major tick labels.}

\item{major_label_text_color}{(color) The text color of the major tick labels.}

\item{major_label_text_font}{(string - 'Helvetica') The text font of the major tick labels.}

\item{major_label_text_font_size}{(string - e.g. '12pt') The text font size of the major tick labels.}

\item{major_label_text_font_style}{('normal', 'italic', 'bold') The text font style of the major tick labels.}

\item{major_tick_in}{(integer) The distance in pixels that major ticks should extend into the main plot area.}

\item{major_tick_line_alpha}{(numeric) The line alpha of the major ticks.}

\item{major_tick_line_cap}{('butt', 'round', 'square') The line cap of the major ticks.}

\item{major_tick_line_color}{(color) The line color of the major ticks.}

\item{major_tick_line_dash}{The line dash of the major ticks.}

\item{major_tick_line_dash_offset}{(integer) The line dash offset of the major ticks.}

\item{major_tick_line_join}{('miter', 'round', 'bevel') The line join of the major ticks.}

\item{major_tick_line_width}{(integer) The line width of the major ticks.}

\item{major_tick_out}{(integer) The distance in pixels that major ticks should extend out of the main plot area.}

\item{minor_tick_in}{(integer) The distance in pixels that minor ticks should extend into the main plot area.}

\item{minor_tick_line_alpha}{(numeric) The line alpha of the minor ticks.}

\item{minor_tick_line_cap}{('butt', 'round', 'square') The line cap of the minor ticks.}

\item{minor_tick_line_color}{(color) The line color of the minor ticks.}

\item{minor_tick_line_dash}{The line dash of the minor ticks.}

\item{minor_tick_line_dash_offset}{(integer) The line dash offset of the minor ticks.}

\item{minor_tick_line_join}{('miter', 'round', 'bevel') The line join of the minor ticks.}

\item{minor_tick_line_width}{(integer) The line width of the minor ticks.}

\item{minor_tick_out}{(integer) The distance in pixels that major ticks should extend out of the main plot area.}

\item{pars}{optionally specify a named list of all parameters - useful when dealing with theme lists}
}
\description{
Override theme parameters for axis attributes
}
\examples{
\donttest{
# manually specify a ggplot-like grid and background
figure() \%>\%
  ly_points(1:10) \%>\%
  theme_plot(background_fill = "#E6E6E6",
    outline_line_color = "white") \%>\%
  theme_grid(c("x", "y"), grid_line_color = "white",
    minor_grid_line_color = "white",
    minor_grid_line_alpha = 0.4) \%>\%
  theme_axis(c("x", "y"), axis_line_color = "white",
    major_label_text_color = "#7F7F7F",
    major_tick_line_color = "#7F7F7F",
    minor_tick_line_alpha = 0, num_minor_ticks = 2)

# or use the built in ggplot theme (under development)
figure() \%>\%
  ly_points(1:10) \%>\%
  set_theme(bk_ggplot_theme)

# or to set the theme for all future plots
options(bokeh_theme = bk_ggplot_theme)

figure() \%>\%
  ly_points(1:10)

figure() \%>\%
  ly_boxplot(1:10)

}
}

