% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.R
\name{d_lagscale}
\alias{d_lagscale}
\title{Calculate delta from a lagged scale coefficient}
\usage{
d_lagscale(delta, dlag, is_post_ice)
}
\arguments{
\item{delta}{a numeric vector. Determines the baseline amount of delta
to be applied to each visit.}

\item{dlag}{a numeric vector. Determines the scaling to be applied
to \code{delta} based upon with visit the ICE occurred on. Must be the same
length as delta.}

\item{is_post_ice}{logical vector. Indicates whether a visit is "post-ICE" or
not.}
}
\description{
Calculates a delta value based upon a baseline delta value and a
post ICE scaling coefficient.
}
\details{
See \code{\link[=delta_template]{delta_template()}} for full details on how this calculation is performed.
}
