% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmrm.R
\name{random_effects_expr}
\alias{random_effects_expr}
\title{Construct random effects formula}
\usage{
random_effects_expr(
  cov_struct = c("us", "toep", "cs", "ar1"),
  cov_by_group = FALSE
)
}
\arguments{
\item{cov_struct}{Character - The covariance structure to be used, must be one of \code{"us"},
\code{"toep"}, \code{"cs"}, \code{"ar1"}}

\item{cov_by_group}{Boolean - Whenever or not to use separate covariances per each group level}
}
\description{
Constructs a character representation of the random effects formula
for fitting a MMRM for subject by visit in the format required for \code{\link[mmrm:mmrm]{mmrm::mmrm()}}.
}
\details{
For example assuming the user specified a covariance structure of "us" and that no groups
were provided this will return

\if{html}{\out{<div class="sourceCode">}}\preformatted{us(visit | subjid)
}\if{html}{\out{</div>}}

If \code{cov_by_group} is set to \code{FALSE} then this indicates that separate covariance matrices
are required per group and as such the following will be returned:

\if{html}{\out{<div class="sourceCode">}}\preformatted{us( visit | group / subjid )
}\if{html}{\out{</div>}}
}
