% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{get_mmrm_sample}
\alias{get_mmrm_sample}
\title{Fit MMRM and returns parameter estimates}
\usage{
get_mmrm_sample(ids, longdata, method, optimizer)
}
\arguments{
\item{ids}{vector of characters containing the ids of the subjects.}

\item{longdata}{R6 \code{longdata} object containing all relevant input data information.}

\item{method}{A \code{method} object as generated by either
\code{\link[=method_approxbayes]{method_approxbayes()}} or \code{\link[=method_condmean]{method_condmean()}}.}

\item{optimizer}{vector of characters defining the optimizer to be used.
Every optimizer must be one of the \code{\link[stats:optim]{stats::optim()}} function. The list of possible
optimizers are Nelder-Mead,
BFGS,
CG,
L-BFGS-B,
SANN,
Brent,.}
}
\value{
A named list of class \code{sample_single}. It contains the following:
\itemize{
\item \code{ids} vector of characters containing the ids of the subjects included in the original dataset.
\item \code{beta} numeric vector of estimated regression coefficients.
\item \code{sigma} list of estimated covariance matrices (one for each level of \code{vars$group}).
\item \code{theta} numeric vector of transformed covariances.
\item \code{failed} logical. \code{TRUE} if the model fit failed.
\item \code{ids_samp} vector of characters containing the ids of the subjects included in the given sample.
}
}
\description{
\code{get_mmrm_sample} fits the base imputation model using a ML/REML approach.
Returns the parameter estimates from the fit.
}
