% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_entity.R
\name{BlockEntity}
\alias{BlockEntity}
\alias{get_block_entity_data}
\alias{get_block_entity_values}
\alias{get_block_entity_value}
\alias{put_block_entity_values}
\alias{put_block_entity_value}
\alias{put_block_entity_data}
\title{Load and store BlockEntity NBT data}
\usage{
get_block_entity_data(db, x, z, dimension)

get_block_entity_values(db, x, z, dimension)

get_block_entity_value(db, x, z, dimension)

put_block_entity_values(db, x, z, dimension, values)

put_block_entity_value(db, x, z, dimension, value)

put_block_entity_data(db, data)
}
\arguments{
\item{db}{A bedrockdb object.}

\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{values}{A list of nbt objects}

\item{value}{An nbt object.}

\item{data}{A named-list specifying key-value pairs.}
}
\value{
\code{get_block_entity_data()} returns a named-list of nbt data.
\code{get_block_entity_values()} returns a single nbt value.
}
\description{
BlockEntity data (tag 49) holds a list of NBT values for
entity data associated with specific blocks.

\code{get_block_entity_data()} and \code{get_block_entity_value()} load BlockEntity
data from \code{db}. \code{get_block_entity_data()} will silently drop and keys not
representing BlockEntity data. \code{get_block_entity_value()} supports loading
only a single value. \code{get_block_entity_values()} is a synonym for
\code{get_block_entity_data()}.

\code{put_block_entity_values()}, \code{put_block_entity_value()}, and
\code{put_block_entity_data()} store BlockEntity data into \code{db}.
}
