% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsa.R
\name{HSA}
\alias{HSA}
\alias{get_hsa_data}
\alias{get_hsa_values}
\alias{get_hsa_value}
\alias{read_hsa_value}
\alias{put_hsa_data}
\alias{put_hsa_values}
\alias{put_hsa_value}
\alias{write_hsa_value}
\title{Read and write HardcodedSpawnArea (HSA) data}
\usage{
get_hsa_data(db, x, z, dimension)

get_hsa_values(db, x, z, dimension)

get_hsa_value(db, x, z, dimension)

read_hsa_value(rawdata)

put_hsa_data(db, data, merge = TRUE)

put_hsa_values(db, x, z, dimension, values)

put_hsa_value(db, x, z, dimension, value)

write_hsa_value(value)
}
\arguments{
\item{db}{A bedrockdb object.}

\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{rawdata}{A scalar raw.}

\item{data}{A table containing HSA coordinates.}

\item{merge}{Merge the new HSAs with existing HSAs.}

\item{values}{A list of tables containing HSA coordinates and tags.}

\item{value}{A table containing HSA coordinates}
}
\value{
\code{get_hsa_data()} returns a table in the same format
as \code{get_hsa_value()}.

\code{get_hsa_value()} and \code{read_hsa_value()}
return a table with columns indicating the
coordinates of the HSA bounding box and the
location of the HSS at the center of the bounding
box. \code{get_hsa_value()} also records the dimension
of the bounding box.
}
\description{
HardcodedSpawnArea (HSA) data (tag 57) stores information
about any structure spawning locations in a chunk.
An HSA is defined by a bounding box that specifies
the location of an HSA in a chunk and a tag that
specifies the type: 1 = NetherFortress, 2 = SwampHut,
3 = OceanMonument, and 5 = PillagerOutpost.

\code{get_hsa_data()} loads HardcodedSpawnArea data from a \code{bedrockdb}.
It will silently drop and keys not representing HSA data.
\code{get_hsa_values()} is a synonym for \code{get_hsa_data()}.

\code{get_hsa_value()} loads HSA data from a \code{bedrockdb}.
It only supports loading a single value.

\code{read_hsa_value()} decodes HSA data.

\code{put_hsa_data()} puts HSA data into a \code{bedrockdb}.
HSA bounding boxes will be split across chunks and

\code{put_hsa_values()} and \code{put_hsa_value()} store HSA data
into a \code{bedrockdb}.

\code{write_hsa_value()} encodes HSA data.
}
\examples{
dbpath <- rbedrock_example_world("example1.mcworld")
db <- bedrockdb(dbpath)
# view all HSA in a world
hsa <- get_hsa_data(db, get_keys(db))
hsa
# add an HSA to a world
dat <- data.frame(x1 = 0, x2 = 15, z1 = 0, z2 = 15,
                  y1 = 40, y2 = 60, tag = "SwampHut")
put_hsa_data(db, dat, merge = TRUE)
close(db)
}
