% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shadow.R
\name{add_shadow}
\alias{add_shadow}
\title{Add Shadow}
\usage{
add_shadow(hillshade, shadowmap, max_darken = 0.7, rescale_original = FALSE)
}
\arguments{
\item{hillshade}{A three-dimensional RGB array or 2D matrix of shadow intensities.}

\item{shadowmap}{A matrix that incidates the intensity of the shadow at that point. 0 is full darkness, 1 is full light.}

\item{max_darken}{Default `0.7`. The lower limit for how much the image will be darkened. 0 is completely black,
1 means the shadow map will have no effect.}

\item{rescale_original}{Default `FALSE`. If `TRUE`, `hillshade` will be scaled to match the dimensions of `shadowmap` (instead of
the other way around).}
}
\value{
Shaded texture map.
}
\description{
Multiplies a texture array or shadow map by a shadow map.
}
\examples{
#First we plot the sphere_shade() hillshade of `montereybay` with no shadows

\donttest{
montereybay \%>\%
 sphere_shade(colorintensity=0.5) \%>\%
 plot_map()
}

#Raytrace the `montereybay` elevation map and add that shadow to the output of sphere_shade()
\donttest{
montereybay \%>\%
 sphere_shade(colorintensity=0.5) \%>\%
 add_shadow(ray_shade(montereybay,sunaltitude=20,zscale=50),max_darken=0.3) \%>\%
 plot_map()
}

#Increase the intensity of the shadow map with the max_darken argument.
\donttest{
montereybay \%>\%
 sphere_shade(colorintensity=0.5) \%>\%
 add_shadow(ray_shade(montereybay,sunaltitude=20,zscale=50),max_darken=0.1) \%>\%
 plot_map()
}

#Decrease the intensity of the shadow map.
\donttest{
montereybay \%>\%
 sphere_shade(colorintensity=0.5) \%>\%
 add_shadow(ray_shade(montereybay,sunaltitude=20,zscale=50),max_darken=0.7) \%>\%
 plot_map()
}
}
