% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{disk}
\alias{disk}
\title{Disk Object}
\usage{
disk(
  x = 0,
  y = 0,
  z = 0,
  radius = 1,
  inner_radius = 0,
  material = diffuse(),
  angle = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  flipped = FALSE,
  scale = c(1, 1, 1)
)
}
\arguments{
\item{x}{Default `0`. x-coordinate of the center of the disk}

\item{y}{Default `0`. y-coordinate of the center of the disk}

\item{z}{Default `0`. z-coordinate of the center of the disk}

\item{radius}{Default `1`. Radius of the disk.}

\item{inner_radius}{Default `0`. Inner radius of the disk.}

\item{material}{Default  \code{\link{diffuse}}.The material, called from one of the material 
functions \code{\link{diffuse}}, \code{\link{metal}}, or \code{\link{dielectric}}.}

\item{angle}{Default `c(0, 0, 0)`. Angle of rotation around the x, y, and z axes, applied in the order specified in `order_rotation`.}

\item{order_rotation}{Default `c(1, 2, 3)`. The order to apply the rotations, referring to "x", "y", and "z".}

\item{flipped}{Default `FALSE`. Whether to flip the normals.}

\item{scale}{Default `c(1, 1, 1)`. Scale transformation in the x, y, and z directions. If this is a single value,
number, the object will be scaled uniformly.
Note: emissive objects may not currently function correctly when scaled.}
}
\value{
Single row of a tibble describing the disk in the scene.
}
\description{
Disk Object
}
\examples{
#Generate a disk in the cornell box.
if(run_documentation()) {
generate_cornell() \%>\%
  add_object(disk(x = 555/2, y = 50, z = 555/2, radius = 150, 
                  material = diffuse(color = "orange"))) \%>\%
  render_scene(lookfrom = c(278, 278, -800) ,lookat = c(278, 278, 0), fov = 40, 
               ambient_light = FALSE, samples = 128, parallel = TRUE, clamp_value = 5)
}
#Rotate the disk.
if(run_documentation()) {
generate_cornell() \%>\%
  add_object(disk(x = 555/2, y = 555/2, z = 555/2, radius = 150, angle = c(-45, 0, 0), 
                  material = diffuse(color = "orange"))) \%>\%
  render_scene(lookfrom = c(278, 278, -800) , lookat = c(278, 278, 0), fov = 40, 
               ambient_light = FALSE, samples = 128, parallel = TRUE, clamp_value = 5)
}
#Pass a value for the inner radius.
if(run_documentation()) {
generate_cornell() \%>\% 
  add_object(disk(x = 555/2, y = 555/2, z = 555/2, 
                  radius = 150, inner_radius = 75, angle = c(-45, 0, 0), 
                  material = diffuse(color = "orange"))) \%>\%
  render_scene(lookfrom = c(278, 278, -800) ,lookat = c(278, 278, 0), fov = 40, 
               ambient_light = FALSE, samples = 128, parallel = TRUE, clamp_value = 5)
}
}
