% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-preprocess.R
\name{RAVEPreprocessSettings}
\alias{RAVEPreprocessSettings}
\title{Definition for preprocess configurations}
\description{
Definition for preprocess configurations

Definition for preprocess configurations
}
\examples{

# The following example require downloading demo subject (~700 MB) from
# https://github.com/beauchamplab/rave/releases/tag/v0.1.9-beta

\dontrun{

conf <- RAVEPreprocessSettings$new(subject = 'demo/DemoSubject')
conf$blocks  # "008" "010" "011" "012"

conf$electrodes   # 5 electrodes

# Electrode 14 information
conf$electrode_info(electrode = 14)

conf$data_imported # All 5 electrodes are imported

conf$data_locked   # Whether block, sample rates should be locked

}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{current_version}}{current configuration setting version}

\item{\code{path}}{settings file path}

\item{\code{backup_path}}{alternative back up path for redundancy checks}

\item{\code{data}}{list of raw configurations, internally used only}

\item{\code{subject}}{\code{\link{RAVESubject}} instance}

\item{\code{read_only}}{whether the configuration should be read-only,
not yet implemented}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{version}}{configure version of currently stored files}

\item{\code{old_version}}{whether settings file is old format}

\item{\code{blocks}}{experiment blocks}

\item{\code{electrodes}}{electrode numbers}

\item{\code{sample_rates}}{voltage data sample rate}

\item{\code{notch_filtered}}{whether electrodes are notch filtered}

\item{\code{has_wavelet}}{whether each electrode has wavelet transforms}

\item{\code{data_imported}}{whether electrodes are imported}

\item{\code{data_locked}}{whether electrode, blocks and sample rate are locked?
usually when an electrode is imported into 'rave', that electrode is
locked}

\item{\code{electrode_locked}}{whether electrode is imported and locked}

\item{\code{wavelet_params}}{wavelet parameters}

\item{\code{notch_params}}{Notch filter parameters}

\item{\code{electrode_types}}{electrode signal types}

\item{\code{@freeze_blocks}}{whether to free block, internally used}

\item{\code{@freeze_lfp_ecog}}{whether to freeze electrodes that record
'LFP' and 'ECoG' signals, internally used}

\item{\code{@lfp_ecog_sample_rate}}{'LFP' and 'ECoG' sample rates, internally used}

\item{\code{all_blocks}}{characters, all possible blocks even not included in
some projects}

\item{\code{raw_path}}{raw data path}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RAVEPreprocessSettings$new()}}
\item \href{#method-valid}{\code{RAVEPreprocessSettings$valid()}}
\item \href{#method-has_raw}{\code{RAVEPreprocessSettings$has_raw()}}
\item \href{#method-set_blocks}{\code{RAVEPreprocessSettings$set_blocks()}}
\item \href{#method-set_electrodes}{\code{RAVEPreprocessSettings$set_electrodes()}}
\item \href{#method-set_sample_rates}{\code{RAVEPreprocessSettings$set_sample_rates()}}
\item \href{#method-migrate}{\code{RAVEPreprocessSettings$migrate()}}
\item \href{#method-electrode_info}{\code{RAVEPreprocessSettings$electrode_info()}}
\item \href{#method-save}{\code{RAVEPreprocessSettings$save()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEPreprocessSettings$new(subject, read_only = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject}}{character or \code{\link{RAVESubject}} instance}

\item{\code{read_only}}{whether subject should be read-only (not yet implemented)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-valid"></a>}}
\if{latex}{\out{\hypertarget{method-valid}{}}}
\subsection{Method \code{valid()}}{
whether configuration is valid or not
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEPreprocessSettings$valid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-has_raw"></a>}}
\if{latex}{\out{\hypertarget{method-has_raw}{}}}
\subsection{Method \code{has_raw()}}{
whether raw data folder exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEPreprocessSettings$has_raw()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_blocks"></a>}}
\if{latex}{\out{\hypertarget{method-set_blocks}{}}}
\subsection{Method \code{set_blocks()}}{
set blocks
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEPreprocessSettings$set_blocks(blocks, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{blocks}}{character, combination of session task and run}

\item{\code{force}}{whether to ignore checking. Only used when data
structure is not native, for example, 'BIDS' format}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_electrodes"></a>}}
\if{latex}{\out{\hypertarget{method-set_electrodes}{}}}
\subsection{Method \code{set_electrodes()}}{
set electrodes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEPreprocessSettings$set_electrodes(
  electrodes,
  type = c("LFP", "ECoG", "Spike", "EEG"),
  add = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{electrodes}}{integer vectors}

\item{\code{type}}{type of electrodes, options are \code{LFP}, \code{ECoG},
and \code{Spike}.}

\item{\code{add}}{whether to add to current settings}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_sample_rates"></a>}}
\if{latex}{\out{\hypertarget{method-set_sample_rates}{}}}
\subsection{Method \code{set_sample_rates()}}{
set sample frequency
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEPreprocessSettings$set_sample_rates(
  srate,
  type = c("LFP", "ECoG", "Spike", "EEG")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{srate}}{sample rate, must be positive number}

\item{\code{type}}{electrode type to set sample rate. In 'rave', all electrodes
with the same type must have the same sample rate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-migrate"></a>}}
\if{latex}{\out{\hypertarget{method-migrate}{}}}
\subsection{Method \code{migrate()}}{
convert old format to new formats
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEPreprocessSettings$migrate(force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{whether to force migrate and save settings}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-electrode_info"></a>}}
\if{latex}{\out{\hypertarget{method-electrode_info}{}}}
\subsection{Method \code{electrode_info()}}{
get electrode information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEPreprocessSettings$electrode_info(electrode)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{electrode}}{integer}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list of electrode type, number, etc.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save"></a>}}
\if{latex}{\out{\hypertarget{method-save}{}}}
\subsection{Method \code{save()}}{
save settings to hard disk
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEPreprocessSettings$save()}\if{html}{\out{</div>}}
}

}
}
